<?php
require_once __DIR__ . '/lib.php';

@ini_set('display_errors','0');
@ini_set('log_errors','1');
@set_time_limit(60);

// Token from header (preferred) or query
$t = $_SERVER['HTTP_X_ADMIN_TOKEN'] ?? ($_GET['t'] ?? '');
if (!$t || !hash_equals(ADMIN_TOKEN, $t)) json_out(['error'=>'unauthorized'],401);

$mode = $_GET['mode'] ?? 'merge'; // merge | replace

if (empty($_FILES['file']) || !is_uploaded_file($_FILES['file']['tmp_name'])) {
  json_out(['error' => 'no file uploaded'], 400);
}
$content = file_get_contents($_FILES['file']['tmp_name']);
$payload = json_decode($content, true);
if (!$payload) json_out(['error' => 'invalid json'], 400);

$items = $payload['contests'] ?? $payload;
if (!is_array($items)) json_out(['error' => 'invalid format'], 400);
if (count($items) > 5000) json_out(['error' => 'too many items'], 400);

$pdo = db();
$cols = $pdo->query("PRAGMA table_info(contests)")->fetchAll();
$names = array_map(fn($c)=>$c['name'], $cols);
$hasPinned = in_array('pinned', $names, true);
$hasPinnedAt = in_array('pinnedAt', $names, true);

$attempts = 3;

function is_lock_error($msg): bool {
  $m = strtolower((string)$msg);
  return strpos($m,'database is locked') !== false || strpos($m,'busy') !== false || strpos($m,'locked') !== false;
}

for ($try=1; $try<=$attempts; $try++){
  try {
    $pdo->exec('BEGIN IMMEDIATE');

    if ($mode === 'replace') {
      $pdo->exec('DELETE FROM contests');
    }

        // Prepare INSERT statements depending on schema
    if ($hasPinned && $hasPinnedAt) {
      $stmtWithId = $pdo->prepare('
        INSERT OR REPLACE INTO contests
        (id, shop, productName, endDate, minItems, minSpend, prize1, prize2, prize3, link, createdAt, updatedAt, pinned, pinnedAt)
        VALUES
        (:id, :shop, :productName, :endDate, :minItems, :minSpend, :prize1, :prize2, :prize3, :link, :createdAt, :updatedAt, :pinned, :pinnedAt)
      ');

      $stmtNoId = $pdo->prepare('
        INSERT INTO contests
        (shop, productName, endDate, minItems, minSpend, prize1, prize2, prize3, link, createdAt, updatedAt, pinned, pinnedAt)
        VALUES
        (:shop, :productName, :endDate, :minItems, :minSpend, :prize1, :prize2, :prize3, :link, :createdAt, :updatedAt, :pinned, :pinnedAt)
      ');
    } else {
      $stmtWithId = $pdo->prepare('
        INSERT OR REPLACE INTO contests
        (id, shop, productName, endDate, minItems, minSpend, prize1, prize2, prize3, link, createdAt, updatedAt)
        VALUES
        (:id, :shop, :productName, :endDate, :minItems, :minSpend, :prize1, :prize2, :prize3, :link, :createdAt, :updatedAt)
      ');

      $stmtNoId = $pdo->prepare('
        INSERT INTO contests
        (shop, productName, endDate, minItems, minSpend, prize1, prize2, prize3, link, createdAt, updatedAt)
        VALUES
        (:shop, :productName, :endDate, :minItems, :minSpend, :prize1, :prize2, :prize3, :link, :createdAt, :updatedAt)
      ');
    }

    $now = now_iso();
    $imported = 0;

    foreach ($items as $it) {
      if (!is_array($it)) continue;

      $shop = clean($it['shop'] ?? '');
      $productName = clean($it['productName'] ?? '');
      $endDate = clean($it['endDate'] ?? '');
      $minItems = (int)($it['minItems'] ?? 0);
      $minSpend = (int)($it['minSpend'] ?? 0);
      $prize1 = clean($it['prize1'] ?? '');
      $prize2 = clean($it['prize2'] ?? '');
      $prize3 = clean($it['prize3'] ?? '');
      $link = clean($it['link'] ?? '');
      $pinned = (int)($it['pinned'] ?? 0);
      $pinned = $pinned ? 1 : 0;

      if (!$shop || !$productName || !$endDate || !$prize1 || !$link) continue;
      if (!validate_date($endDate)) continue;
      if (!validate_url($link)) continue;

      $createdAt = clean($it['createdAt'] ?? $now);
      $updatedAt = clean($it['updatedAt'] ?? $now);
      $pinnedAt  = clean($it['pinnedAt'] ?? ($pinned ? $now : ''));
      if (!$pinned) $pinnedAt = '';

      $params = [
        ':shop' => $shop,
        ':productName' => $productName,
        ':endDate' => $endDate,
        ':minItems' => max(0,$minItems),
        ':minSpend' => max(0,$minSpend),
        ':prize1' => $prize1,
        ':prize2' => $prize2,
        ':prize3' => $prize3,
        ':link' => $link,
        ':createdAt' => $createdAt,
        ':updatedAt' => $updatedAt,
        ':pinned' => $pinned,
        ':pinnedAt' => $pinnedAt,
      ];
      if (!($hasPinned && $hasPinnedAt)) {
        unset($params[':pinned']);
        unset($params[':pinnedAt']);
      }

      $id = (int)($it['id'] ?? 0);
      if ($id > 0) {
        $params[':id'] = $id;
        $stmtWithId->execute($params);
      } else {
        $stmtNoId->execute($params);
      }
      $imported++;
    }

    $pdo->commit();
    json_out(['ok'=>true,'imported'=>$imported,'mode'=>$mode]);
  } catch (Throwable $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    if ($try < $attempts && is_lock_error($e->getMessage())) {
      usleep(250000 * $try);
      continue;
    }
    json_out(['error'=>'import failed','details'=>$e->getMessage()],500);
  }
}
