<?php
require_once __DIR__ . '/lib.php';

// Token from header (preferred) or query
$t = $_SERVER['HTTP_X_ADMIN_TOKEN'] ?? ($_GET['t'] ?? '');
if (!$t || !hash_equals(ADMIN_TOKEN, $t)) json_out(['error'=>'unauthorized'],401);

header('Content-Type: application/json; charset=utf-8');
header('Content-Disposition: attachment; filename="souteze-export.json"');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');

$rows = db()->query('SELECT * FROM contests ORDER BY pinned DESC, endDate ASC, datetime(createdAt) DESC')->fetchAll();
echo json_encode([
  'exportedAt' => now_iso(),
  'version' => 1,
  'contests' => $rows
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
