<?php
require_once __DIR__ . '/lib.php';

$t = $_SERVER['HTTP_X_ADMIN_TOKEN'] ?? ($_GET['t'] ?? '');
if (!$t || !hash_equals(ADMIN_TOKEN, $t)) { http_response_code(401); echo "unauthorized"; exit; }

header('Content-Type: text/plain; charset=utf-8');

echo "OK DIAG\n";
echo "PHP: " . PHP_VERSION . "\n";
echo "DB_PATH: " . DB_PATH . "\n";
echo "DB exists: " . (file_exists(DB_PATH) ? "yes" : "no") . "\n";
$dir = dirname(DB_PATH);
echo "Dir writable: " . (is_writable($dir) ? "yes" : "no") . " (" . $dir . ")\n";
if (file_exists(DB_PATH)) echo "DB writable: " . (is_writable(DB_PATH) ? "yes" : "no") . "\n";

$pdo = db();
$cols = $pdo->query("PRAGMA table_info(contests)")->fetchAll();
echo "Columns: " . implode(", ", array_map(fn($c)=>$c['name'], $cols)) . "\n";

try {
  $pdo->exec("BEGIN IMMEDIATE");
  $now = now_iso();
  $pdo->prepare("INSERT INTO contests (shop,productName,endDate,minItems,minSpend,prize1,prize2,prize3,link,createdAt,updatedAt) VALUES (?,?,?,?,?,?,?,?,?,?,?)")
      ->execute(["DIAG","DIAG","2099-12-31",0,0,"DIAG","","","https://example.com",$now,$now]);
  $pdo->exec("ROLLBACK");
  echo "Write test: OK (rolled back)\n";
} catch (Throwable $e) {
  if ($pdo->inTransaction()) $pdo->rollBack();
  echo "Write test: FAIL: " . $e->getMessage() . "\n";
}
