<?php
require_once __DIR__ . '/lib.php';
$a = $_GET['action'] ?? '';

if ($a === 'add') {
  require_token();
  $b = json_decode(file_get_contents('php://input'), true) ?? [];

  $shop = clean($b['shop'] ?? '');
  $productName = clean($b['productName'] ?? '');
  $endDate = clean($b['endDate'] ?? '');
  $minItems = (int)($b['minItems'] ?? 0);
  $minSpend = (int)($b['minSpend'] ?? 0);
  $prize1 = clean($b['prize1'] ?? '');
  $prize2 = clean($b['prize2'] ?? '');
  $prize3 = clean($b['prize3'] ?? '');
  $link = clean($b['link'] ?? '');

  if (!$shop || !$productName || !$endDate || !$prize1 || !$link) json_out(['error'=>'missing fields'],400);
  if (!validate_date($endDate)) json_out(['error'=>'bad endDate'],400);
  if (!validate_url($link)) json_out(['error'=>'bad link'],400);

  $now = now_iso();
  db()->prepare('
    INSERT INTO contests (shop,productName,endDate,minItems,minSpend,prize1,prize2,prize3,link,createdAt,updatedAt,pinned)
    VALUES (?,?,?,?,?,?,?,?,?,?,?,?)
  ')->execute([
    $shop,$productName,$endDate,max(0,$minItems),max(0,$minSpend),
    $prize1,$prize2,$prize3,$link,$now,$now,(int)($b['pinned']??0)
  ]);

  json_out(['ok'=>true]);
}

if ($a === 'update') {
  require_token();
  $id = (int)($_GET['id'] ?? 0);
  if ($id <= 0) json_out(['error'=>'bad id'],400);

  $b = json_decode(file_get_contents('php://input'), true) ?? [];

  $shop = clean($b['shop'] ?? '');
  $productName = clean($b['productName'] ?? '');
  $endDate = clean($b['endDate'] ?? '');
  $minItems = (int)($b['minItems'] ?? 0);
  $minSpend = (int)($b['minSpend'] ?? 0);
  $prize1 = clean($b['prize1'] ?? '');
  $prize2 = clean($b['prize2'] ?? '');
  $prize3 = clean($b['prize3'] ?? '');
  $link = clean($b['link'] ?? '');

  if (!$shop || !$productName || !$endDate || !$prize1 || !$link) json_out(['error'=>'missing fields'],400);
  if (!validate_date($endDate)) json_out(['error'=>'bad endDate'],400);
  if (!validate_url($link)) json_out(['error'=>'bad link'],400);

  $now = now_iso();
  $stmt = db()->prepare('
    UPDATE contests
    SET shop=?, productName=?, endDate=?, minItems=?, minSpend=?, prize1=?, prize2=?, prize3=?, link=?, updatedAt=?, pinned=?
    WHERE id=?
  ');
  $stmt->execute([
    $shop,$productName,$endDate,max(0,$minItems),max(0,$minSpend),
    $prize1,$prize2,$prize3,$link,$now,(int)($b['pinned']??0),$id
  ]);

  json_out(['ok'=>true]);
}

if ($a === 'delete') {
  require_token();
  $id = (int)($_GET['id'] ?? 0);
  if ($id <= 0) json_out(['error'=>'bad id'],400);
  db()->prepare('DELETE FROM contests WHERE id=?')->execute([$id]);
  json_out(['ok'=>true]);
}

if ($a === 'list') {
  $rows = db()->query('SELECT * FROM contests ORDER BY pinned DESC, date(endDate) ASC')->fetchAll();
  json_out($rows);
}


if ($a === 'export') {
  require_token();
  header('Content-Type: application/json; charset=utf-8');
  header('Content-Disposition: attachment; filename="souteze-export.json"');
  header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');

  $rows = db()->query('SELECT * FROM contests ORDER BY pinned DESC, endDate ASC, datetime(createdAt) DESC')->fetchAll();
  echo json_encode([
    'exportedAt' => now_iso(),
    'version' => 1,
    'contests' => $rows
  ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
  exit;
}


if ($a === 'import_file') {
  require_token();
  $mode = $_GET['mode'] ?? 'merge'; // merge | replace
  // allow bigger imports
  @set_time_limit(60);

  if (empty($_FILES['file']) || !is_uploaded_file($_FILES['file']['tmp_name'])) {
    json_out(['error' => 'no file uploaded'], 400);
  }
  $content = file_get_contents($_FILES['file']['tmp_name']);
  $payload = json_decode($content, true);
  if (!$payload) json_out(['error' => 'invalid json'], 400);

  // Reuse the same logic as JSON-body import by injecting into php://input style variable
  $items = $payload['contests'] ?? $payload;
  if (!is_array($items)) json_out(['error' => 'invalid format'], 400);
  if (count($items) > 5000) json_out(['error' => 'too many items'], 400);

  $pdo = db();
  $pdo->beginTransaction();
  try {
    if ($mode === 'replace') {
      $pdo->exec('DELETE FROM contests');
    }

    $stmtWithId = $pdo->prepare('
      INSERT OR REPLACE INTO contests
      (id, shop, productName, endDate, minItems, minSpend, prize1, prize2, prize3, link, createdAt, updatedAt, pinned, pinnedAt)
      VALUES
      (:id, :shop, :productName, :endDate, :minItems, :minSpend, :prize1, :prize2, :prize3, :link, :createdAt, :updatedAt, :pinned, :pinnedAt)
    ');

    $stmtNoId = $pdo->prepare('
      INSERT INTO contests
      (shop, productName, endDate, minItems, minSpend, prize1, prize2, prize3, link, createdAt, updatedAt, pinned, pinnedAt)
      VALUES
      (:shop, :productName, :endDate, :minItems, :minSpend, :prize1, :prize2, :prize3, :link, :createdAt, :updatedAt, :pinned, :pinnedAt)
    ');

    $now = now_iso();
    $imported = 0;

    foreach ($items as $it) {
      if (!is_array($it)) continue;

      $shop = clean($it['shop'] ?? '');
      $productName = clean($it['productName'] ?? '');
      $endDate = clean($it['endDate'] ?? '');
      $minItems = (int)($it['minItems'] ?? 0);
      $minSpend = (int)($it['minSpend'] ?? 0);
      $prize1 = clean($it['prize1'] ?? '');
      $prize2 = clean($it['prize2'] ?? '');
      $prize3 = clean($it['prize3'] ?? '');
      $link = clean($it['link'] ?? '');
      $pinned = (int)($it['pinned'] ?? 0);
      $pinned = $pinned ? 1 : 0;

      if (!$shop || !$productName || !$endDate || !$prize1 || !$link) continue;
      if (!validate_date($endDate)) continue;
      if (!validate_url($link)) continue;

      $createdAt = clean($it['createdAt'] ?? $now);
      $updatedAt = clean($it['updatedAt'] ?? $now);
      $pinnedAt  = clean($it['pinnedAt'] ?? ($pinned ? $now : ''));
      if (!$pinned) $pinnedAt = '';

      $params = [
        ':shop' => $shop,
        ':productName' => $productName,
        ':endDate' => $endDate,
        ':minItems' => max(0, $minItems),
        ':minSpend' => max(0, $minSpend),
        ':prize1' => $prize1,
        ':prize2' => $prize2,
        ':prize3' => $prize3,
        ':link' => $link,
        ':createdAt' => $createdAt,
        ':updatedAt' => $updatedAt,
        ':pinned' => $pinned,
        ':pinnedAt' => $pinnedAt,
      ];

      $id = (int)($it['id'] ?? 0);
      if ($id > 0) {
        $params[':id'] = $id;
        $stmtWithId->execute($params);
      } else {
        $stmtNoId->execute($params);
      }
      $imported++;
    }

    $pdo->commit();
    json_out(['ok' => true, 'imported' => $imported, 'mode' => $mode]);
  } catch (Throwable $e) {
    $pdo->rollBack();
    json_out(['error' => 'import failed'], 500);
  }
}


if ($a === 'import') {
  require_token();
  $mode = $_GET['mode'] ?? 'merge'; // merge | replace

  $payload = json_decode(file_get_contents('php://input'), true);
  if (!$payload) json_out(['error' => 'invalid json'], 400);

  $items = $payload['contests'] ?? $payload; // allow raw array or wrapped format
  if (!is_array($items)) json_out(['error' => 'invalid format'], 400);

  if (count($items) > 5000) json_out(['error' => 'too many items'], 400);

  $pdo = db();
  $pdo->beginTransaction();
  try {
    if ($mode === 'replace') {
      $pdo->exec('DELETE FROM contests');
    }

    $stmtWithId = $pdo->prepare('
      INSERT OR REPLACE INTO contests
      (id, shop, productName, endDate, minItems, minSpend, prize1, prize2, prize3, link, createdAt, updatedAt, pinned, pinnedAt)
      VALUES
      (:id, :shop, :productName, :endDate, :minItems, :minSpend, :prize1, :prize2, :prize3, :link, :createdAt, :updatedAt, :pinned, :pinnedAt)
    ');

    $stmtNoId = $pdo->prepare('
      INSERT INTO contests
      (shop, productName, endDate, minItems, minSpend, prize1, prize2, prize3, link, createdAt, updatedAt, pinned, pinnedAt)
      VALUES
      (:shop, :productName, :endDate, :minItems, :minSpend, :prize1, :prize2, :prize3, :link, :createdAt, :updatedAt, :pinned, :pinnedAt)
    ');

    $now = now_iso();
    $imported = 0;

    foreach ($items as $it) {
      if (!is_array($it)) continue;

      $shop = clean($it['shop'] ?? '');
      $productName = clean($it['productName'] ?? '');
      $endDate = clean($it['endDate'] ?? '');
      $minItems = (int)($it['minItems'] ?? 0);
      $minSpend = (int)($it['minSpend'] ?? 0);
      $prize1 = clean($it['prize1'] ?? '');
      $prize2 = clean($it['prize2'] ?? '');
      $prize3 = clean($it['prize3'] ?? '');
      $link = clean($it['link'] ?? '');
      $pinned = (int)($it['pinned'] ?? 0);
      $pinned = $pinned ? 1 : 0;

      if (!$shop || !$productName || !$endDate || !$prize1 || !$link) continue;
      if (!validate_date($endDate)) continue;
      if (!validate_url($link)) continue;

      $createdAt = clean($it['createdAt'] ?? $now);
      $updatedAt = clean($it['updatedAt'] ?? $now);
      $pinnedAt  = clean($it['pinnedAt'] ?? ($pinned ? $now : ''));
      if (!$pinned) $pinnedAt = '';

      $params = [
        ':shop' => $shop,
        ':productName' => $productName,
        ':endDate' => $endDate,
        ':minItems' => max(0, $minItems),
        ':minSpend' => max(0, $minSpend),
        ':prize1' => $prize1,
        ':prize2' => $prize2,
        ':prize3' => $prize3,
        ':link' => $link,
        ':createdAt' => $createdAt,
        ':updatedAt' => $updatedAt,
        ':pinned' => $pinned,
        ':pinnedAt' => $pinnedAt,
      ];

      $id = (int)($it['id'] ?? 0);
      if ($id > 0) {
        $params[':id'] = $id;
        $stmtWithId->execute($params);
      } else {
        $stmtNoId->execute($params);
      }
      $imported++;
    }

    $pdo->commit();
    json_out(['ok' => true, 'imported' => $imported, 'mode' => $mode]);
  } catch (Throwable $e) {
    $pdo->rollBack();
    json_out(['error' => 'import failed'], 500);
  }
}


if ($a === 'latest') {
  $row = db()->query('SELECT updatedAt FROM contests ORDER BY datetime(updatedAt) DESC LIMIT 1')->fetch();
  $latest = $row ? $row['updatedAt'] : '';
  $count = (int)db()->query('SELECT COUNT(*) AS c FROM contests')->fetch()['c'];
  json_out(['latest'=>$latest,'count'=>$count]);
}

json_out(['error'=>'bad action'],404);
