<?php
require_once __DIR__ . '/config.php';

function db(): PDO {
  static $pdo = null;
  if ($pdo) return $pdo;

  $dir = dirname(DB_PATH);
  if (!is_dir($dir)) mkdir($dir, 0777, true);

  $pdo = new PDO('sqlite:' . DB_PATH, null, null, [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  ]);
  $pdo->exec('PRAGMA journal_mode = WAL;\n  $pdo->exec('PRAGMA busy_timeout = 8000;');');

  $pdo->exec('
    CREATE TABLE IF NOT EXISTS contests (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      shop TEXT NOT NULL,
      productName TEXT NOT NULL,
      endDate TEXT NOT NULL,
      minItems INTEGER NOT NULL DEFAULT 0,
      minSpend INTEGER NOT NULL DEFAULT 0,
      prize1 TEXT NOT NULL,
      prize2 TEXT DEFAULT "",
      prize3 TEXT DEFAULT "",
      link TEXT NOT NULL,
      createdAt TEXT NOT NULL,
      updatedAt TEXT NOT NULL,
      pinned INTEGER NOT NULL DEFAULT 0
    )
  ');

  $pdo->exec('CREATE INDEX IF NOT EXISTS idx_contests_updatedAt ON contests(updatedAt);');
  $pdo->exec('CREATE INDEX IF NOT EXISTS idx_contests_createdAt ON contests(createdAt);');

  return $pdo;
}

function json_out($d, $c=200){
  http_response_code($c);
  header('Content-Type: application/json; charset=utf-8');
  header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
  echo json_encode($d, JSON_UNESCAPED_UNICODE);
  exit;
}

function require_token(){
  $t = (string)($_GET['t'] ?? '');
  if (!$t || !hash_equals(ADMIN_TOKEN, $t)) json_out(['error'=>'unauthorized'],401);
}

function now_iso(): string { return gmdate('c'); }

function validate_date(string $d): bool {
  return (bool)preg_match('/^\d{4}-\d{2}-\d{2}$/', $d);
}

function validate_url(string $u): bool {
  return (bool)filter_var($u, FILTER_VALIDATE_URL);
}

function clean($s): string { return trim((string)$s); }
