<?php require_once __DIR__ . '/config.php'; ?>
<!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Přehled soutěží</title>
  <link rel="stylesheet" href="./styles.css" />
</head>
<body>
  <div class="container">
    <header class="row space">
      <div>
        <h1>Přehled soutěží</h1>
        <p class="muted">Automatická aktualizace každých <?php echo (int)POLL_MS; ?> ms.</p>
      </div>
    </header>

    <section class="card">
      <h2>Filtrovat soutěže</h2>
      <div class="grid">
        <div>
          <div class="muted small">Obchody:</div>
          <div id="shopCheckboxes" class="checkboxes"></div>
          <label class="chk" style="margin-top:10px;">
            <input type="checkbox" id="activeOnly"> Jen aktivní soutěže
          </label>
        </div>

        <label>
          Řazení:
          <select id="sort">
            <option value="newest">Nejnovější</option>
            <option value="oldest">Nejstarší</option>
            <option value="endSoonest">Konec nejdřív</option>
            <option value="endLatest">Konec nejpozději</option>
          </select>
        </label>

        <div class="actions span2">
          <button class="btn" id="apply">Použít</button>
          <button class="btn ghost" id="clear">Vymazat</button>
          <span class="muted small" id="rtStatus"></span>
        </div>
      </div>
    </section>

    <section class="card">
      <h2>Seznam soutěží</h2>
      <div id="list" class="list"></div>
    </section>
  </div>

  <script>window.__POLL_MS__=<?php echo (int)POLL_MS; ?>;</script>
  <script src="./app.js"></script>
</body>
</html>
