<?php
require_once __DIR__ . '/lib.php';
$a = $_GET['action'] ?? '';

if ($a === 'add') {
  require_token();
  $b = json_decode(file_get_contents('php://input'), true) ?? [];

  $shop = clean($b['shop'] ?? '');
  $productName = clean($b['productName'] ?? '');
  $endDate = clean($b['endDate'] ?? '');
  $minItems = (int)($b['minItems'] ?? 0);
  $minSpend = (int)($b['minSpend'] ?? 0);
  $prize1 = clean($b['prize1'] ?? '');
  $prize2 = clean($b['prize2'] ?? '');
  $prize3 = clean($b['prize3'] ?? '');
  $link = clean($b['link'] ?? '');

  if (!$shop || !$productName || !$endDate || !$prize1 || !$link) json_out(['error'=>'missing fields'],400);
  if (!validate_date($endDate)) json_out(['error'=>'bad endDate'],400);
  if (!validate_url($link)) json_out(['error'=>'bad link'],400);

  $now = now_iso();
  db()->prepare('
    INSERT INTO contests (shop,productName,endDate,minItems,minSpend,prize1,prize2,prize3,link,createdAt,updatedAt,pinned)
    VALUES (?,?,?,?,?,?,?,?,?,?,?,?)
  ')->execute([
    $shop,$productName,$endDate,max(0,$minItems),max(0,$minSpend),
    $prize1,$prize2,$prize3,$link,$now,$now,(int)($b['pinned']??0)
  ]);

  json_out(['ok'=>true]);
}

if ($a === 'update') {
  require_token();
  $id = (int)($_GET['id'] ?? 0);
  if ($id <= 0) json_out(['error'=>'bad id'],400);

  $b = json_decode(file_get_contents('php://input'), true) ?? [];

  $shop = clean($b['shop'] ?? '');
  $productName = clean($b['productName'] ?? '');
  $endDate = clean($b['endDate'] ?? '');
  $minItems = (int)($b['minItems'] ?? 0);
  $minSpend = (int)($b['minSpend'] ?? 0);
  $prize1 = clean($b['prize1'] ?? '');
  $prize2 = clean($b['prize2'] ?? '');
  $prize3 = clean($b['prize3'] ?? '');
  $link = clean($b['link'] ?? '');

  if (!$shop || !$productName || !$endDate || !$prize1 || !$link) json_out(['error'=>'missing fields'],400);
  if (!validate_date($endDate)) json_out(['error'=>'bad endDate'],400);
  if (!validate_url($link)) json_out(['error'=>'bad link'],400);

  $now = now_iso();
  $stmt = db()->prepare('
    UPDATE contests
    SET shop=?, productName=?, endDate=?, minItems=?, minSpend=?, prize1=?, prize2=?, prize3=?, link=?, updatedAt=?, pinned=?
    WHERE id=?
  ');
  $stmt->execute([
    $shop,$productName,$endDate,max(0,$minItems),max(0,$minSpend),
    $prize1,$prize2,$prize3,$link,$now,(int)($b['pinned']??0),$id
  ]);

  json_out(['ok'=>true]);
}

if ($a === 'delete') {
  require_token();
  $id = (int)($_GET['id'] ?? 0);
  if ($id <= 0) json_out(['error'=>'bad id'],400);
  db()->prepare('DELETE FROM contests WHERE id=?')->execute([$id]);
  json_out(['ok'=>true]);
}

if ($a === 'list') {
  $rows = db()->query('SELECT * FROM contests ORDER BY pinned DESC, date(endDate) ASC')->fetchAll();
  json_out($rows);
}

if ($a === 'latest') {
  $row = db()->query('SELECT updatedAt FROM contests ORDER BY datetime(updatedAt) DESC LIMIT 1')->fetch();
  $latest = $row ? $row['updatedAt'] : '';
  $count = (int)db()->query('SELECT COUNT(*) AS c FROM contests')->fetch()['c'];
  json_out(['latest'=>$latest,'count'=>$count]);
}

json_out(['error'=>'bad action'],404);
