(() => {
  const T = String(window.__ADMIN_TOKEN__ || "");
  const adminList = document.getElementById("adminList");
  const msg = document.getElementById("msg");
  const saveBtn = document.getElementById("saveBtn");
  const cancelEditBtn = document.getElementById("cancelEdit");
  const formTitle = document.getElementById("formTitle");

  const f = {
    shop: document.getElementById("shop"),
    productName: document.getElementById("productName"),
    endDate: document.getElementById("endDate"),
    minItems: document.getElementById("minItems"),
    minSpend: document.getElementById("minSpend"),
    prize1: document.getElementById("prize1"),
    prize2: document.getElementById("prize2"),
    prize3: document.getElementById("prize3"),
    link: document.getElementById("link"),
    pinned: document.getElementById("pinned"),
  };

  let editId = null;

  function escapeHtml(str) {
    return String(str ?? "")
      .replaceAll("&","&amp;").replaceAll("<","&lt;").replaceAll(">","&gt;")
      .replaceAll('"',"&quot;").replaceAll("'","&#039;");
  }
  function escapeAttr(str){ return escapeHtml(str).replaceAll("`","&#096;"); }

  function setModeAdd(){
    editId = null;
    formTitle.textContent = "Přidat soutěž";
    saveBtn.textContent = "Přidat soutěž";
    cancelEditBtn.classList.add("hidden");
    msg.textContent = "";
    // nečistíme shop, ať se dá přidávat víc položek pro stejný obchod
    f.productName.value = "";
    f.endDate.value = "";
    f.minItems.value = 0;
    f.minSpend.value = 0;
    f.prize1.value = "";
    f.prize2.value = "";
    f.prize3.value = "";
    f.link.value = "";
    f.pinned.checked = false;
  }

  function setModeEdit(item){
    editId = item.id;
    formTitle.textContent = "Editovat soutěž #" + item.id;
    saveBtn.textContent = "Uložit změny";
    cancelEditBtn.classList.remove("hidden");
    msg.textContent = "";

    f.shop.value = item.shop || "";
    f.productName.value = item.productName || "";
    f.endDate.value = item.endDate || "";
    f.minItems.value = Number(item.minItems)||0;
    f.minSpend.value = Number(item.minSpend)||0;
    f.prize1.value = item.prize1 || "";
    f.prize2.value = item.prize2 || "";
    f.prize3.value = item.prize3 || "";
    f.link.value = item.link || "";
    f.pinned.checked = Number(item.pinned) === 1;
    window.scrollTo({ top: 0, behavior: "smooth" });
  }

  cancelEditBtn.addEventListener("click", setModeAdd);

  async function api(action, opts = {}){
    const url = "./api.php?action=" + encodeURIComponent(action) + "&t=" + encodeURIComponent(T) + (opts.id ? "&id=" + encodeURIComponent(opts.id) : "");
    const res = await fetch(url, {
      method: opts.method || "GET",
      headers: opts.headers || {},
      body: opts.body,
      cache: "no-store",
    });
    const txt = await res.text();
    let data = null;
    try { data = txt ? JSON.parse(txt) : null; } catch { data = null; }
    if (!res.ok) throw new Error((data && data.error) ? data.error : ("HTTP " + res.status));
    return data;
  }

  async function loadList(){
    const r = await fetch("./api.php?action=list", { cache:"no-store" });
    const items = await r.json();

    if (!items.length) {
      adminList.innerHTML = `<div class="muted">Zatím nic.</div>`;
      return;
    }

    adminList.innerHTML = items.map(c => `
      <div class="item">
        <div class="row space">
          <div>
            <div class="title">${escapeHtml(c.productName)}</div>
            <div class="muted small">${escapeHtml(c.shop)} • končí ${escapeHtml(c.endDate)}</div>
          </div>
          <div class="row" style="gap:8px;">
            <button class="btn small" data-edit="${escapeAttr(c.id)}">Edit</button>
            <button class="btn danger small" data-del="${escapeAttr(c.id)}">Smazat</button>
          </div>
        </div>
        <div class="muted small"><a href="${escapeAttr(c.link)}" target="_blank" rel="noopener">${escapeHtml(c.link)}</a></div>
      </div>
    `).join("");

    adminList.querySelectorAll("[data-del]").forEach(btn => {
      btn.addEventListener("click", async () => {
        msg.textContent = "";
        const id = btn.getAttribute("data-del");
        if (!confirm("Opravdu smazat soutěž #" + id + "?")) return;
        try {
          await api("delete", { method:"POST", id });
          await loadList();
          if (String(editId) === String(id)) setModeAdd();
        } catch (e) {
          msg.textContent = "Chyba při mazání: " + e.message;
        }
      });
    });

    adminList.querySelectorAll("[data-edit]").forEach(btn => {
      btn.addEventListener("click", () => {
        const id = btn.getAttribute("data-edit");
        const item = items.find(x => String(x.id) === String(id));
        if (item) setModeEdit(item);
      });
    });
  }

  saveBtn.addEventListener("click", async () => {
    msg.textContent = "";

    const payload = {
      shop: f.shop.value,
      productName: f.productName.value,
      endDate: f.endDate.value,
      minItems: f.minItems.value,
      minSpend: f.minSpend.value,
      prize1: f.prize1.value,
      prize2: f.prize2.value,
      prize3: f.prize3.value,
      link: f.link.value,
      pinned: f.pinned.checked ? 1 : 0,
    };

    try {
      if (editId) {
        await api("update", {
          method: "POST",
          id: editId,
          headers: { "Content-Type":"application/json" },
          body: JSON.stringify(payload),
        });
        msg.textContent = "✅ Uloženo.";
      } else {
        await api("add", {
          method: "POST",
          headers: { "Content-Type":"application/json" },
          body: JSON.stringify(payload),
        });
        msg.textContent = "✅ Přidáno.";
      }

      await loadList();
      setModeAdd();
    } catch (e) {
      msg.textContent = "Chyba: " + e.message;
    }
  });

  // init
  setModeAdd();
  loadList();
})(); 
