<?php require_once __DIR__ . '/config.php'; ?>
<!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Admin – Soutěže</title>
  <link rel="stylesheet" href="./styles.css" />
</head>
<body>
  <div class="container">
    <header class="row space">
      <div>
        <h1>Admin</h1>
        <p class="muted">Bez hesla (tajná URL). Umí přidat, <b>editovat</b> a mazat.</p>
      </div>
      <a class="btn ghost" href="./index.php">Veřejná stránka</a>
    </header>

    <section class="card">
      <div class="row space">
        <h2 id="formTitle">Přidat soutěž</h2>
        <div class="row" style="gap:8px;">
          <button class="btn ghost hidden" id="cancelEdit">Zrušit editaci</button>
        </div>
      </div>

      <div class="grid">
        <label>Obchod: <input id="shop" /></label>
        <label>Název produktu: <input id="productName" /></label>
        <label>Datum ukončení: <input id="endDate" type="date" /></label>
        <label>Počet produktů: <input id="minItems" type="number" min="0" value="0" /></label>
        <label>Min. útrata (Kč): <input id="minSpend" type="number" min="0" value="0" /></label>
        <label>První cena: <input id="prize1" /></label>
        <label>Druhá cena: <input id="prize2" /></label>
        <label>Třetí cena: <input id="prize3" /></label>
        <label class="span2">Odkaz: <input id="link" placeholder="https://..." /></label>

        <div class="actions span2">
          <button class="btn" id="saveBtn">Přidat soutěž</button>
          <div id="msg" class="muted"></div>
        </div>
      </div>
    </section>

    <section class="card">
      <h2>Seznam (správa)</h2>
      <div id="adminList" class="list"></div>
    </section>
  </div>

  <script>
    window.__ADMIN_TOKEN__ = <?php echo json_encode(ADMIN_TOKEN); ?>;
  </script>
  <script src="./admin.js"></script>
</body>
</html>
