(() => {
  const listEl = document.getElementById("list");
  const rtStatus = document.getElementById("rtStatus");
  const POLL_MS = Number(window.__POLL_MS__ || 3000);

  let lastLatest = "";
  let lastCount = -1;

  function escapeHtml(str) {
    return String(str ?? "")
      .replaceAll("&","&amp;").replaceAll("<","&lt;").replaceAll(">","&gt;")
      .replaceAll('"',"&quot;").replaceAll("'","&#039;");
  }
  function escapeAttr(str){ return escapeHtml(str).replaceAll("`","&#096;"); }
  function isActive(endDate){
    const end = new Date(endDate + "T23:59:59");
    return end.getTime() >= Date.now();
  }

  function render(items){
    if (!items.length) {
      listEl.innerHTML = `<div class="muted">Zatím tu nejsou žádné soutěže.</div>`;
      return;
    }
    listEl.innerHTML = items.map(c => `
      <div class="item">
        <div class="itemTop">
          <div class="title">${escapeHtml(c.productName)}
            ${isActive(c.endDate) ? `<span class="badge ok">aktivní</span>` : `<span class="badge">ukončeno</span>`}
          </div>
          <div class="muted small">${escapeHtml(c.shop)} • končí: <b>${escapeHtml(c.endDate)}</b></div>
        </div>
        <div class="meta">
          <div><b>Počet produktů:</b> ${Number(c.minItems)||0}</div>
          <div><b>Min. útrata:</b> ${Number(c.minSpend)||0} Kč</div>
        </div>
        <div class="prizes">
          <div><b>1. cena:</b> ${escapeHtml(c.prize1)}</div>
          ${c.prize2 ? `<div><b>2. cena:</b> ${escapeHtml(c.prize2)}</div>` : ""}
          ${c.prize3 ? `<div><b>3. cena:</b> ${escapeHtml(c.prize3)}</div>` : ""}
        </div>
        <div class="links">
          <a class="btn small" href="${escapeAttr(c.link)}" target="_blank" rel="noopener">Odkaz na soutěž</a>
        </div>
      </div>
    `).join("");
  }

  async function load(){
    const r = await fetch("./api.php?action=list", { cache:"no-store" });
    const items = await r.json();
    render(items);
  }

  async function poll(){
    try{
      const r = await fetch("./api.php?action=latest", { cache:"no-store" });
      const j = await r.json();
      const changed = (j.latest !== lastLatest) || (j.count !== lastCount);
      lastLatest = j.latest; lastCount = j.count;
      rtStatus.textContent = changed ? "Aktualizuji…" : "Sledování změn…";
      if (changed) await load();
      rtStatus.textContent = "Sledování změn…";
    }catch(e){
      rtStatus.textContent = "Problém se spojením…";
      console.error(e);
    }
  }

  (async () => {
    await load();
    await poll();
    setInterval(poll, POLL_MS);
  })();
})(); 
