// Login functionality
document.getElementById('login-btn').addEventListener('click', function() {
    const username = document.getElementById('admin-username').value;
    const password = document.getElementById('admin-password').value;
    const correctUsername = 'jarda';
    const correctPassword = 'jarda';

    if (username === correctUsername && password === correctPassword) {
        document.getElementById('login-container').style.display = 'none';
        document.getElementById('form-container').style.display = 'block';
        document.getElementById('logout-btn').style.display = 'block';
        document.getElementById('login-error').style.display = 'none';
    } else {
        document.getElementById('login-error').style.display = 'block';
    }
});

// Logout functionality
document.getElementById('logout-btn').addEventListener('click', function() {
    document.getElementById('login-container').style.display = 'block';
    document.getElementById('form-container').style.display = 'none';
    document.getElementById('logout-btn').style.display = 'none';
    document.getElementById('admin-username').value = '';
    document.getElementById('admin-password').value = '';
});


// Initialize when DOM is loaded
document.addEventListener('DOMContentLoaded', function() {
    loadCompetitions();
});

// Form submission
document.getElementById('competition-form').addEventListener('submit', function(e) {
    e.preventDefault();
    const formData = {
        store: document.getElementById('store').value,
        productName: document.getElementById('product-name').value,
        endDate: document.getElementById('end-date').value,
        products: document.getElementById('products').value,
        minPayment: parseFloat(document.getElementById('min-payment').value),
        firstPrize: document.getElementById('first-prize').value,
        secondPrize: document.getElementById('second-prize').value,
        thirdPrize: document.getElementById('third-prize').value,
        link: document.getElementById('link').value
    };

    fetch('/api.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(formData)
    })
    .then(response => response.text())
    .then(data => {
        alert('Soutěž byla úspěšně přidána!');
        document.getElementById('competition-form').reset();
        loadCompetitions(); // Reload the list
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Chyba při ukládání soutěže.');
    });
});

// Load competitions from server
function loadCompetitions() {
    fetch('/api.php')
    .then(response => response.json())
    .then(competitions => {
        displayCompetitions(competitions);
    })
    .catch(error => {
        console.error('Error loading competitions:', error);
    });
}

// Display competitions
function displayCompetitions(competitions) {
    const container = document.getElementById('competitions');
    container.innerHTML = '';
    competitions.forEach(comp => {
        const compDiv = document.createElement('div');
        compDiv.className = 'competition';
        compDiv.innerHTML = `
            <h3>${comp.productName}</h3>
            <p><strong>Obchod:</strong> ${comp.store}</p>
            <p><strong>Datum ukončení:</strong> ${comp.endDate}</p>
            <p><strong>Počet produktů:</strong> ${comp.products}</p>
            <p><strong>Minimální útrata:</strong> ${comp.minPayment} Kč</p>
            <p><strong>První cena:</strong> ${comp.firstPrize}</p>
            ${comp.secondPrize ? `<p><strong>Druhá cena:</strong> ${comp.secondPrize}</p>` : ''}
            ${comp.thirdPrize ? `<p><strong>Třetí cena:</strong> ${comp.thirdPrize}</p>` : ''}
            ${comp.link ? `<p><a href="${comp.link}" target="_blank">Odkaz na soutěž</a></p>` : ''}
        `;
        container.appendChild(compDiv);
    });
}