PRAGMA foreign_keys = ON;
BEGIN TRANSACTION;

CREATE TABLE IF NOT EXISTS rooms (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  name TEXT NOT NULL,
  capacity INTEGER NOT NULL DEFAULT 2
);

CREATE TABLE IF NOT EXISTS users (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  email TEXT NOT NULL UNIQUE,
  password_hash TEXT NOT NULL,
  role TEXT NOT NULL DEFAULT 'admin' CHECK (role IN ('admin','staff')),
  created_at TEXT NOT NULL DEFAULT CURRENT_TIMESTAMP
);

-- Reservations and blocks share one table via type
CREATE TABLE IF NOT EXISTS bookings (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  room_id INTEGER NOT NULL,
  type TEXT NOT NULL DEFAULT 'reservation' CHECK (type IN ('reservation','block')),
  start_date TEXT NOT NULL, -- YYYY-MM-DD
  end_date TEXT NOT NULL,   -- checkout (exclusive)
  title TEXT NULL,
  customer_name TEXT NULL,
  email TEXT NULL,
  phone TEXT NULL,
  total_price REAL NULL,
  created_at TEXT NOT NULL DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (room_id) REFERENCES rooms(id) ON DELETE RESTRICT
);

-- Pricing
CREATE TABLE IF NOT EXISTS room_rates (
  room_id INTEGER PRIMARY KEY,
  base_price REAL NOT NULL,
  currency TEXT NOT NULL DEFAULT 'CZK',
  FOREIGN KEY (room_id) REFERENCES rooms(id) ON DELETE RESTRICT
);

CREATE TABLE IF NOT EXISTS seasons (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  name TEXT NOT NULL,
  start_date TEXT NOT NULL,
  end_date TEXT NOT NULL,
  multiplier REAL NOT NULL DEFAULT 1.0
);

CREATE TABLE IF NOT EXISTS discounts (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  code TEXT NOT NULL UNIQUE,
  name TEXT NOT NULL,
  percent_off REAL NOT NULL DEFAULT 0.0,
  active INTEGER NOT NULL DEFAULT 1
);

-- Seed data: 6 rooms
INSERT INTO rooms (name, capacity) VALUES
('Pokoj 1', 2),
('Pokoj 2', 2),
('Pokoj 3', 3),
('Pokoj 4', 2),
('Pokoj 5', 4),
('Pokoj 6', 2);

-- Default base prices (edit as needed)
INSERT INTO room_rates (room_id, base_price, currency) VALUES
(1, 1200.00, 'CZK'),
(2, 1200.00, 'CZK'),
(3, 1500.00, 'CZK'),
(4, 1200.00, 'CZK'),
(5, 1800.00, 'CZK'),
(6, 1200.00, 'CZK');

-- Example season
INSERT INTO seasons (name, start_date, end_date, multiplier) VALUES
('Letni sezona', '2026-06-01', '2026-09-01', 1.2);

-- Example discount
INSERT INTO discounts (code, name, percent_off, active) VALUES
('WELCOME10', 'Uvitaci sleva', 10.0, 1);

-- Default admin user: admin@example.com / admin123
-- IMPORTANT: Change password after first login.
INSERT INTO users (email, password_hash, role)
VALUES (
  'admin@example.com',
  '$2y$10$uOxjZ.5JdGqu89o6A5W1aOWE9BqQMGq5tZPqzvE6y0Bf4gAq3rR8S',
  'admin'
);

COMMIT;
