CREATE DATABASE IF NOT EXISTS rooms_booking
  DEFAULT CHARACTER SET utf8mb4
  DEFAULT COLLATE utf8mb4_unicode_ci;

USE rooms_booking;

CREATE TABLE IF NOT EXISTS rooms (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(50) NOT NULL,
  capacity INT NOT NULL DEFAULT 2
);

CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  email VARCHAR(190) NOT NULL UNIQUE,
  password_hash VARCHAR(255) NOT NULL,
  role ENUM('admin','staff') NOT NULL DEFAULT 'admin',
  created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
);

-- Reservations and blocks share one table via type
CREATE TABLE IF NOT EXISTS bookings (
  id INT AUTO_INCREMENT PRIMARY KEY,
  room_id INT NOT NULL,
  type ENUM('reservation','block') NOT NULL DEFAULT 'reservation',
  start_date DATE NOT NULL,
  end_date DATE NOT NULL, -- checkout (exclusive)
  title VARCHAR(200) NULL, -- for block label or custom
  customer_name VARCHAR(120) NULL,
  email VARCHAR(190) NULL,
  phone VARCHAR(50) NULL,
  total_price DECIMAL(10,2) NULL,
  created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  CONSTRAINT fk_book_room FOREIGN KEY (room_id) REFERENCES rooms(id)
);

-- Pricing
CREATE TABLE IF NOT EXISTS room_rates (
  room_id INT PRIMARY KEY,
  base_price DECIMAL(10,2) NOT NULL,
  currency CHAR(3) NOT NULL DEFAULT 'CZK',
  CONSTRAINT fk_rate_room FOREIGN KEY (room_id) REFERENCES rooms(id)
);

CREATE TABLE IF NOT EXISTS seasons (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120) NOT NULL,
  start_date DATE NOT NULL,
  end_date DATE NOT NULL,
  multiplier DECIMAL(6,3) NOT NULL DEFAULT 1.000
);

CREATE TABLE IF NOT EXISTS discounts (
  id INT AUTO_INCREMENT PRIMARY KEY,
  code VARCHAR(40) NOT NULL UNIQUE,
  name VARCHAR(120) NOT NULL,
  percent_off DECIMAL(5,2) NOT NULL DEFAULT 0.00,
  active TINYINT(1) NOT NULL DEFAULT 1
);

-- Seed data: 6 rooms
INSERT INTO rooms (name, capacity) VALUES
('Pokoj 1', 2),
('Pokoj 2', 2),
('Pokoj 3', 3),
('Pokoj 4', 2),
('Pokoj 5', 4),
('Pokoj 6', 2);

-- Default base prices (edit as needed)
INSERT INTO room_rates (room_id, base_price, currency) VALUES
(1, 1200.00, 'CZK'),
(2, 1200.00, 'CZK'),
(3, 1500.00, 'CZK'),
(4, 1200.00, 'CZK'),
(5, 1800.00, 'CZK'),
(6, 1200.00, 'CZK');

-- Example season
INSERT INTO seasons (name, start_date, end_date, multiplier) VALUES
('Letni sezona', '2026-06-01', '2026-09-01', 1.200);

-- Example discount
INSERT INTO discounts (code, name, percent_off, active) VALUES
('WELCOME10', 'Uvitaci sleva', 10.00, 1);

-- Create default admin user: admin@example.com / admin123
-- IMPORTANT: Change password after first login.
INSERT INTO users (email, password_hash, role)
VALUES (
  'admin@example.com',
  '$2y$10$uOxjZ.5JdGqu89o6A5W1aOWE9BqQMGq5tZPqzvE6y0Bf4gAq3rR8S',
  'admin'
);
