<!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Rezervace pokojů</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.15/index.global.min.css">
  <link rel="stylesheet" href="../assets/app.css" />
</head>
<body>
  <header class="topbar">
    <div class="topbar__left">
      <h1>Rezervace pokojů</h1>
      <p>Vyber rozsah nocí v kalendáři a odešli rezervaci.</p>
    </div>
    <div class="topbar__right">
      <label class="field">
        <span>Pokoj</span>
        <select id="roomSelect"></select>
      </label>
      <a class="btn btn--ghost" href="../admin/login.php">Admin</a>
    </div>
  </header>

  <main class="layout">
    <section class="card">
      <div id="calendar"></div>
      <div class="hint">Kliknutím/tažením vybereš termín. Události označují obsazeno/blokace.</div>
      <div id="status" class="status" aria-live="polite"></div>
    </section>

    <section class="card card--form">
      <h2>Objednat noc(e)</h2>
      <form id="bookingForm">
        <div class="grid">
          <label class="field">
            <span>Od (check-in)</span>
            <input class="input" type="date" id="startDate" required />
          </label>
          <label class="field">
            <span>Do (check-out)</span>
            <input class="input" type="date" id="endDate" required />
          </label>
          <label class="field">
            <span>Jméno</span>
            <input class="input" type="text" id="customerName" required />
          </label>
          <label class="field">
            <span>Email</span>
            <input class="input" type="email" id="email" />
          </label>
          <label class="field">
            <span>Telefon</span>
            <input class="input" type="text" id="phone" />
          </label>
          <label class="field">
            <span>Slevový kód</span>
            <input class="input" type="text" id="discount" placeholder="např. WELCOME10" />
          </label>
        </div>

        <div class="row row--space">
          <button class="btn" type="submit">Odeslat rezervaci</button>
          <button class="btn btn--ghost" id="quoteBtn" type="button">Spočítat cenu</button>
        </div>

        <div id="quoteBox" class="quote"></div>
      </form>
    </section>
  </main>

  <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.15/index.global.min.js"></script>
  <script type="module" src="../assets/public.js"></script>
</body>
</html>
