export async function apiGet(url){
  const r = await fetch(url,{headers:{Accept:'application/json'}});
  const j = await r.json();
  if(!r.ok) throw new Error(j.error||'Request failed');
  return j;
}

export async function apiSend(url,method,payload){
  const r = await fetch(url,{
    method,
    headers:{Accept:'application/json','Content-Type':'application/json'},
    body: payload ? JSON.stringify(payload) : null
  });
  const j = await r.json();
  if(!r.ok) throw new Error(j.error||'Request failed');
  return j;
}

export function setStatus(msg,isError=false){
  const el = document.getElementById('status');
  if(!el) return;
  el.textContent = msg || '';
  el.style.color = isError ? '#b00020' : '#0a7a2f';
}
