import { apiGet, apiSend, setStatus } from './ui.js';

let calendar;
let rooms=[];

async function loadRooms(){
  const r = await apiGet('../api/rooms.php');
  rooms=r.rooms;
  const sel=document.getElementById('roomSelect');
  sel.innerHTML = rooms.map(x=>`<option value="${x.id}">${x.name} (od ${x.base_price} ${x.currency}/noc)</option>`).join('');
}

async function initCalendar(){
  const calEl=document.getElementById('calendar');
  calendar = new FullCalendar.Calendar(calEl,{
    initialView:'dayGridMonth',
    firstDay:1,
    height:'auto',
    selectable:true,
    headerToolbar:{left:'prev,next today',center:'title',right:'dayGridMonth,timeGridWeek'},
    events: async (info, success, failure)=>{
      try{
        const roomId = Number(document.getElementById('roomSelect').value);
        const url = `../api/bookings.php?start=${encodeURIComponent(info.startStr)}&end=${encodeURIComponent(info.endStr)}&room_id=${roomId}`;
        const data = await apiGet(url);
        success((data.events||[]).map(e=>{
          // public: show less info
          return {...e, title: e.extendedProps.type==='block' ? 'BLOKACE' : 'OBSAZENO'};
        }));
      }catch(e){failure(e)}
    },
    select:(sel)=>{
      document.getElementById('startDate').value = sel.startStr;
      document.getElementById('endDate').value = sel.endStr;
      setStatus('Vyplň údaje a odešli rezervaci (nebo si nechej spočítat cenu).');
    }
  });
  calendar.render();
}

async function quote(){
  const roomId = Number(document.getElementById('roomSelect').value);
  const start = document.getElementById('startDate').value;
  const end = document.getElementById('endDate').value;
  const discount = document.getElementById('discount').value.trim();
  const q = await apiGet(`../api/pricing.php?action=quote&room_id=${roomId}&start_date=${encodeURIComponent(start)}&end_date=${encodeURIComponent(end)}&discount=${encodeURIComponent(discount)}`);
  const out = document.getElementById('quoteBox');
  out.innerHTML = `
    <div><b>Noci:</b> ${q.nights}</div>
    <div><b>Mezisoučet:</b> ${q.subtotal} ${q.currency}</div>
    <div><b>Sleva:</b> ${q.discount_amount} ${q.currency} (${q.discount_percent}%)</div>
    <div class="total"><b>Celkem:</b> ${q.total} ${q.currency}</div>
  `;
}

async function bind(){
  document.getElementById('roomSelect').addEventListener('change', ()=>calendar.refetchEvents());

  document.getElementById('quoteBtn').addEventListener('click', async ()=>{
    try{ setStatus(''); await quote(); setStatus('Cena spočítána ✅'); }catch(e){ setStatus(e.message,true); }
  });

  document.getElementById('bookingForm').addEventListener('submit', async (ev)=>{
    ev.preventDefault();
    setStatus('');
    const payload={
      room_id: Number(document.getElementById('roomSelect').value),
      start_date: document.getElementById('startDate').value,
      end_date: document.getElementById('endDate').value,
      customer_name: document.getElementById('customerName').value.trim(),
      email: document.getElementById('email').value.trim(),
      phone: document.getElementById('phone').value.trim(),
      discount: document.getElementById('discount').value.trim(),
    };
    try{
      const res = await apiSend('../api/public_booking.php','POST',payload);
      document.getElementById('quoteBox').innerHTML = `<div class="total"><b>Rezervace přijata.</b> Cena: ${res.quote.total} ${res.quote.currency}</div>`;
      setStatus('Rezervace vytvořena ✅');
      calendar.refetchEvents();
      ev.target.reset();
    }catch(e){
      setStatus(e.message,true);
    }
  });
}

async function main(){
  await loadRooms();
  await initCalendar();
  await bind();
}

main().catch(e=>{
  console.error(e);
  setStatus('Chyba při startu.',true);
});
