import { apiGet, apiSend, setStatus } from './ui.js';

async function load(){
  const data = await apiGet('../api/pricing.php?action=meta');

  document.getElementById('ratesBox').innerHTML = (data.rates||[]).map(r =>
    `<div>Pokoj ${r.room_id}: <b>${r.base_price}</b> ${r.currency}</div>`
  ).join('') || '<div class="muted">Žádné ceny.</div>';

  document.getElementById('seasonsBox').innerHTML = (data.seasons||[]).map(s =>
    `<div class="row row--space">
      <div>#${s.id} <b>${s.name}</b> (${s.start_date} → ${s.end_date}) koef: ${s.multiplier}</div>
      <button class="btn btn--small btn--danger" data-del-season="${s.id}">Smazat</button>
    </div>`
  ).join('') || '<div class="muted">Žádné sezóny.</div>';

  document.getElementById('discountsBox').innerHTML = (data.discounts||[]).map(d =>
    `<div class="row row--space">
      <div>#${d.id} <b>${d.code}</b> – ${d.name} (${d.percent_off}%) ${d.active==1?'':'[neaktivní]'}</div>
      <button class="btn btn--small btn--danger" data-del-discount="${d.id}">Smazat</button>
    </div>`
  ).join('') || '<div class="muted">Žádné slevy.</div>';

  bindDelete();
}

function bindDelete(){
  document.querySelectorAll('[data-del-season]').forEach(btn => {
    btn.addEventListener('click', async ()=>{
      const id = btn.getAttribute('data-del-season');
      if(!confirm('Smazat sezónu?')) return;
      try{ await apiSend(`../api/pricing.php?action=season&id=${encodeURIComponent(id)}`,'DELETE'); setStatus('Smazáno ✅'); await load(); }
      catch(e){ setStatus(e.message,true); }
    });
  });
  document.querySelectorAll('[data-del-discount]').forEach(btn => {
    btn.addEventListener('click', async ()=>{
      const id = btn.getAttribute('data-del-discount');
      if(!confirm('Smazat slevu?')) return;
      try{ await apiSend(`../api/pricing.php?action=discount&id=${encodeURIComponent(id)}`,'DELETE'); setStatus('Smazáno ✅'); await load(); }
      catch(e){ setStatus(e.message,true); }
    });
  });
}

async function main(){
  await load();

  document.getElementById('seasonForm').addEventListener('submit', async (ev)=>{
    ev.preventDefault();
    setStatus('');
    const fd = new FormData(ev.target);
    const payload = Object.fromEntries(fd.entries());
    payload.multiplier = Number(payload.multiplier);
    try{ await apiSend('../api/pricing.php?action=season','POST',payload); ev.target.reset(); setStatus('Sezóna přidána ✅'); await load(); }
    catch(e){ setStatus(e.message,true); }
  });

  document.getElementById('discountForm').addEventListener('submit', async (ev)=>{
    ev.preventDefault();
    setStatus('');
    const fd = new FormData(ev.target);
    const payload = Object.fromEntries(fd.entries());
    payload.percent_off = Number(payload.percent_off);
    try{ await apiSend('../api/pricing.php?action=discount','POST',payload); ev.target.reset(); setStatus('Sleva přidána ✅'); await load(); }
    catch(e){ setStatus(e.message,true); }
  });

  document.getElementById('logoutBtn').addEventListener('click', async ()=>{
    await apiSend('../api/auth.php?action=logout','POST');
    window.location.href = 'login.php';
  });
}

main().catch(e=>{ console.error(e); setStatus('Chyba.',true); });
