<?php
declare(strict_types=1);

function json_out($data, int $code = 200): void {
  http_response_code($code);
  echo json_encode($data);
  exit;
}

function bad_request(string $msg): void {
  json_out(['error' => $msg], 400);
}

function forbid(string $msg = 'Forbidden'): void {
  json_out(['error' => $msg], 403);
}

function read_json_body(): array {
  $raw = file_get_contents('php://input');
  $data = json_decode($raw, true);
  if (!is_array($data)) {
    bad_request('Invalid JSON');
  }
  return $data;
}

function require_admin(): void {
  if (empty($_SESSION['user'])) {
    forbid('Not logged in');
  }
  $role = $_SESSION['user']['role'] ?? '';
  if ($role !== 'admin' && $role !== 'staff') {
    forbid('Invalid role');
  }
}

function require_admin_only(): void {
  if (empty($_SESSION['user'])) {
    forbid('Not logged in');
  }
  $role = $_SESSION['user']['role'] ?? '';
  if ($role !== 'admin') {
    forbid('Admin only');
  }
}

function iso_date(string $s): bool {
  return (bool)preg_match('/^\d{4}-\d{2}-\d{2}$/', $s);
}

function nights_between(string $start, string $end): int {
  $a = new DateTimeImmutable($start);
  $b = new DateTimeImmutable($end);
  $diff = $a->diff($b);
  return max(0, (int)$diff->days);
}
