<?php
declare(strict_types=1);
require __DIR__ . '/db.php';
require __DIR__ . '/util.php';

$method = $_SERVER['REQUEST_METHOD'];

if ($method !== 'GET') {
  json_out(['error' => 'Method not allowed'], 405);
}

$stmt = $pdo->query(
  "SELECT r.id, r.name, r.capacity, rr.base_price, rr.currency
   FROM rooms r
   LEFT JOIN room_rates rr ON rr.room_id = r.id
   ORDER BY r.id ASC"
);
json_out(['rooms' => $stmt->fetchAll()]);
