<?php
declare(strict_types=1);
require __DIR__ . '/db.php';
require __DIR__ . '/util.php';
require __DIR__ . '/pricing_lib.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  json_out(['error' => 'Method not allowed'], 405);
}

function overlap_exists_public(PDO $pdo, int $roomId, string $start, string $end): bool {
  $stmt = $pdo->prepare(
    "SELECT COUNT(*) AS c FROM bookings
     WHERE room_id = ? AND NOT (end_date <= ? OR start_date >= ?)"
  );
  $stmt->execute([$roomId, $start, $end]);
  return ((int)$stmt->fetch()['c']) > 0;
}

$d = read_json_body();
$roomId = (int)($d['room_id'] ?? 0);
$start = (string)($d['start_date'] ?? '');
$end = (string)($d['end_date'] ?? '');
$name = trim((string)($d['customer_name'] ?? ''));
$email = trim((string)($d['email'] ?? ''));
$phone = trim((string)($d['phone'] ?? ''));
$discount = (string)($d['discount'] ?? '');

if ($roomId <= 0) bad_request('room_id required');
if (!iso_date($start) || !iso_date($end)) bad_request('start_date/end_date required');
if (strtotime($end) <= strtotime($start)) bad_request('end_date must be after start_date');
if ($name === '') bad_request('customer_name required');

$chk = $pdo->prepare('SELECT id FROM rooms WHERE id = ?');
$chk->execute([$roomId]);
if (!$chk->fetch()) bad_request('Room not found');

if (overlap_exists_public($pdo, $roomId, $start, $end)) {
  json_out(['error' => 'Pokoj je v tomto terminu obsazen.'], 409);
}

$quote = compute_quote($pdo, $roomId, $start, $end, $discount);
if (empty($quote['ok'])) {
  json_out(['error' => $quote['error'] ?? 'Pricing failed'], 400);
}

$stmt = $pdo->prepare(
  "INSERT INTO bookings (room_id, type, start_date, end_date, customer_name, email, phone, total_price)
   VALUES (?,?,?,?,?,?,?,?)"
);
$stmt->execute([
  $roomId,
  'reservation',
  $start,
  $end,
  $name,
  ($email !== '' ? $email : null),
  ($phone !== '' ? $phone : null),
  $quote['total'],
]);

json_out(['ok' => true, 'id' => (int)$pdo->lastInsertId(), 'quote' => $quote]);
