<?php
declare(strict_types=1);
require __DIR__ . '/db.php';
require __DIR__ . '/util.php';

$method = $_SERVER['REQUEST_METHOD'];
$action = $_GET['action'] ?? '';

if ($method === 'GET' && $action === 'me') {
  $user = $_SESSION['user'] ?? null;
  json_out(['user' => $user]);
}

if ($method === 'POST' && $action === 'login') {
  $data = read_json_body();
  $email = strtolower(trim((string)($data['email'] ?? '')));
  $password = (string)($data['password'] ?? '');
  if ($email === '' || $password === '') bad_request('Email and password required');

  $stmt = $pdo->prepare('SELECT id, email, password_hash, role FROM users WHERE email = ? LIMIT 1');
  $stmt->execute([$email]);
  $row = $stmt->fetch();
  if (!$row || !password_verify($password, $row['password_hash'])) {
    json_out(['error' => 'Invalid credentials'], 401);
  }

  $_SESSION['user'] = ['id' => (int)$row['id'], 'email' => $row['email'], 'role' => $row['role']];
  json_out(['ok' => true, 'user' => $_SESSION['user']]);
}

if ($method === 'POST' && $action === 'logout') {
  $_SESSION = [];
  if (ini_get('session.use_cookies')) {
    $p = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000, $p['path'], $p['domain'], $p['secure'], $p['httponly']);
  }
  session_destroy();
  json_out(['ok' => true]);
}

json_out(['error' => 'Not found'], 404);
