<?php
session_start();
if (empty($_SESSION['user'])) {
  header('Location: login.php');
  exit;
}
?><!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Cenotvorba</title>
  <link rel="stylesheet" href="../assets/app.css" />
</head>
<body>
  <header class="topbar">
    <div class="topbar__left">
      <h1>Cenotvorba</h1>
      <p>Správa sezon a slev.</p>
    </div>
    <div class="topbar__right">
      <a class="btn btn--ghost" href="dashboard.php">Zpět na dashboard</a>
      <button id="logoutBtn" class="btn btn--ghost" type="button">Odhlásit</button>
    </div>
  </header>

  <main class="layout layout--single">
    <section class="card">
      <h2>Základní ceny (room_rates)</h2>
      <div id="ratesBox" class="mono"></div>

      <hr class="sep" />

      <h2>Sezóny</h2>
      <form id="seasonForm" class="grid grid--3">
        <input class="input" name="name" placeholder="Název" required />
        <input class="input" type="date" name="start_date" required />
        <input class="input" type="date" name="end_date" required />
        <input class="input" name="multiplier" placeholder="Koef. (např. 1.2)" required />
        <button class="btn btn--small" type="submit">Přidat sezónu</button>
      </form>
      <div id="seasonsBox" class="mono"></div>

      <hr class="sep" />

      <h2>Slevy</h2>
      <form id="discountForm" class="grid grid--3">
        <input class="input" name="code" placeholder="Kód" required />
        <input class="input" name="name" placeholder="Název" required />
        <input class="input" name="percent_off" placeholder="%" required />
        <button class="btn btn--small" type="submit">Přidat slevu</button>
      </form>
      <div id="discountsBox" class="mono"></div>

      <div id="status" class="status" aria-live="polite"></div>
    </section>
  </main>

  <script type="module" src="../assets/pricing_admin.js"></script>
</body>
</html>
