<?php
session_start();
if (!empty($_SESSION['user'])) {
  header('Location: dashboard.php');
  exit;
}
?><!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Admin přihlášení</title>
  <link rel="stylesheet" href="../assets/app.css" />
</head>
<body>
  <header class="topbar">
    <div class="topbar__left">
      <h1>Admin – přihlášení</h1>
      <p>Výchozí: admin@example.com / admin123</p>
    </div>
  </header>

  <main class="layout layout--single">
    <section class="card card--form">
      <h2>Přihlášení</h2>
      <form id="loginForm">
        <label class="field">
          <span>Email</span>
          <input type="email" id="email" required value="admin@example.com" />
        </label>
        <label class="field">
          <span>Heslo</span>
          <input type="password" id="password" required value="admin123" />
        </label>
        <button class="btn" type="submit">Přihlásit</button>
        <div id="status" class="status" aria-live="polite"></div>
      </form>
      <div class="note">Po prvním přihlášení si změň heslo v databázi (tabulka <code>users</code>).</div>
    </section>
  </main>

  <script>
    async function apiPost(url, payload) {
      const r = await fetch(url, {
        method: 'POST',
        headers: { 'Content-Type': 'application/json', 'Accept': 'application/json' },
        body: JSON.stringify(payload)
      });
      const j = await r.json();
      if (!r.ok) throw new Error(j.error || 'Request failed');
      return j;
    }
    function setStatus(msg, isError=false) {
      const el = document.getElementById('status');
      el.textContent = msg;
      el.style.color = isError ? '#b00020' : '#0a7a2f';
    }
    document.getElementById('loginForm').addEventListener('submit', async (e) => {
      e.preventDefault();
      setStatus('');
      try {
        await apiPost('../api/auth.php?action=login', {
          email: document.getElementById('email').value,
          password: document.getElementById('password').value,
        });
        window.location.href = 'dashboard.php';
      } catch (err) {
        setStatus(err.message, true);
      }
    });
  </script>
</body>
</html>
