<?php
session_start();
if (empty($_SESSION['user'])) {
  header('Location: login.php');
  exit;
}
$user = $_SESSION['user'];
?><!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Dashboard – obsazenost</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.15/index.global.min.css">
  <link rel="stylesheet" href="../assets/app.css" />
</head>
<body>
  <header class="topbar">
    <div class="topbar__left">
      <h1>Dashboard – obsazenost</h1>
      <p>Přihlášen: <b><?php echo htmlspecialchars($user['email']); ?></b></p>
    </div>
    <div class="topbar__right">
      <label class="field">
        <span>Pokoj</span>
        <select id="roomSelect"></select>
      </label>
      <a class="btn btn--ghost" href="pricing.php">Cenotvorba</a>
      <button id="logoutBtn" class="btn btn--ghost" type="button">Odhlásit</button>
    </div>
  </header>

  <main class="layout">
    <section class="card">
      <div id="calendar"></div>
      <div class="hint">Táhni přes dny pro vytvoření. Klik na událost = úprava/smazání.</div>
      <div id="status" class="status" aria-live="polite"></div>
    </section>

    <section class="card">
      <h2>Obsazenost – seznam (aktuální + další měsíc)</h2>
      <div class="tableWrap">
        <table class="table">
          <thead>
            <tr>
              <th>Pokoj</th><th>Typ</th><th>Od</th><th>Do</th><th>Jméno / název</th><th>Cena</th>
            </tr>
          </thead>
          <tbody id="listBody"></tbody>
        </table>
      </div>
    </section>
  </main>

  <!-- Modal (edit/create) -->
  <div class="modal" id="modal">
    <div class="modal__card">
      <div class="modal__header">
        <h2>Rezervace / blokace</h2>
        <button class="btn btn--ghost btn--small" id="closeModal" type="button">Zavřít</button>
      </div>

      <form id="editForm" class="grid">
        <input type="hidden" id="m_id" />

        <label class="field">
          <span>Pokoj</span>
          <select id="m_room"></select>
        </label>

        <label class="field">
          <span>Typ</span>
          <select id="m_type">
            <option value="reservation">Rezervace</option>
            <option value="block">Blokace</option>
          </select>
        </label>

        <label class="field">
          <span>Od (check-in)</span>
          <input class="input" type="date" id="m_start" required />
        </label>

        <label class="field">
          <span>Do (check-out)</span>
          <input class="input" type="date" id="m_end" required />
        </label>

        <div id="row_title">
          <label class="field">
            <span>Název blokace</span>
            <input class="input" type="text" id="m_title" placeholder="např. Servis" />
          </label>
        </div>

        <div id="row_customer">
          <label class="field">
            <span>Jméno</span>
            <input class="input" type="text" id="m_name" placeholder="Host" />
          </label>
          <label class="field">
            <span>Email</span>
            <input class="input" type="email" id="m_email" placeholder="volitelné" />
          </label>
          <label class="field">
            <span>Telefon</span>
            <input class="input" type="text" id="m_phone" placeholder="volitelné" />
          </label>
          <label class="field">
            <span>Cena celkem</span>
            <input class="input" type="number" step="0.01" id="m_total" placeholder="volitelné" />
          </label>
        </div>

        <div class="row row--space">
          <button class="btn" type="submit">Uložit</button>
          <button class="btn btn--danger" id="deleteBtn" type="button">Smazat</button>
        </div>
      </form>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.15/index.global.min.js"></script>
  <script type="module" src="../assets/admin.js"></script>
</body>
</html>
