# Instalace na Namecheap (sdílený hosting + cPanel) – SQLite (lokální databáze)

Tahle verze nepoužívá MySQL. Data se ukládají do **lokálního souboru SQLite** v rámci projektu, takže po rozbalení ZIPu
většinou stačí jen nastavit práva pro zápis do složky `data/`.

## 0) Co potřebuješ
- Namecheap hosting s **PHP 8.x**
- Zapnuté rozšíření **SQLite3 / PDO SQLite** (na většině Namecheap plánů je)
- Přístup do **cPanelu**

## 1) Nahrání a rozbalení
1. **cPanel → File Manager**
2. Složka **public_html** (nebo document root domény/subdomény)
3. Nahraj ZIP
4. ZIP → **Extract**

### Jaká bude URL?
- Když rozbalíš do `public_html/rooms-booking/`, poběží to na:
  - `https://tvoje-domena.cz/rooms-booking/`
- Pokud chceš root domény (`https://tvoje-domena.cz/`), přesuň **obsah** složky `rooms-booking/` přímo do `public_html/`.

## 2) Nastavení PHP verze
V cPanelu otevři **MultiPHP Manager** (nebo „Select PHP Version“) a nastav pro doménu **PHP 8.0+**.

## 3) Nastav práva pro složku `data/`
Aplikace si při prvním otevření vytvoří databázi soubor `data/app.sqlite` automaticky.

1. Ve File Manageru najdi složku `data/`.
2. Nastav oprávnění (Permissions):
   - zkus nejdřív **755**
   - když to nepůjde, dej **775**
   - u některých hostingů je nutné dočasně **777** (pak vrať zpět na 775)

> Bez práva zápisu do `data/` se DB nevytvoří a uvidíš 500 chybu.

## 4) První start (auto-inicializace DB)
1. Otevři veřejnou část:
   - `…/rooms-booking/public/index.php`
2. Otevři admin login:
   - `…/rooms-booking/admin/login.php`

Při prvním requestu se automaticky provede schéma z `sql/schema_sqlite.sql` a vytvoří se `data/app.sqlite`.

Výchozí admin:
- email: `admin@example.com`
- heslo: `admin123`

## 5) Bezpečnost
- `data/.htaccess` blokuje přístup k DB souboru přes web.
- `api/.htaccess` blokuje přístup k citlivým PHP souborům (např. připojení k DB).

## 6) Když něco nejde (nejčastější problémy)
### A) 500 error hned po otevření
- zkontroluj, že `data/` je zapisovatelná
- v cPanelu zkontroluj **Errors** / error log

### B) SQLite rozšíření není dostupné
- v cPanelu (Select PHP Version) zkontroluj, že je zapnuté **sqlite3** a **pdo_sqlite**
- když tam není, napiš Namecheap supportu, ať ho pro účet zapnou

### C) "Failed to load module script" / špatný MIME typ JS
- v rootu je `.htaccess`, který přidává `AddType application/javascript .js`

---

Chceš, aby URL byla bez `/public` (tj. doména rovnou na veřejný formulář)? Stačí přesunout obsah `public/` do rootu, nebo upravit `.htaccess` – klidně ti to nastavím.
