<?php
require_once __DIR__ . '/../lib/layout.php';
require_once __DIR__ . '/../lib/auth.php';
require_admin();
$pdo = db();

$mode = $_GET['mode'] ?? 'sold'; // sold | box
$boxId = trim($_GET['box'] ?? '');

if ($mode === 'box' && !$boxId) {
  header('Location: ' . base_url('/admin/dashboard.php'));
  exit;
}

if (isset($_GET['download'])) {
  header('Content-Type: text/csv; charset=utf-8');
  header('Content-Disposition: attachment; filename="export_' . $mode . '_' . date('Y-m-d_His') . '.csv"');
  $out = fopen('php://output', 'w');
  // UTF-8 BOM for Excel
  fprintf($out, chr(0xEF).chr(0xBB).chr(0xBF));

  if ($mode === 'sold') {
    $from = trim($_GET['from'] ?? '');
    $to = trim($_GET['to'] ?? '');
    $where = "i.sold=1";
    $params = [];
    if ($from) { $where .= " AND date(i.sold_at) >= date(?)"; $params[] = $from; }
    if ($to)   { $where .= " AND date(i.sold_at) <= date(?)"; $params[] = $to; }

    fputcsv($out, ['datum', 'krabice', 'produkt', 'množství', 'prodejní cena', 'kde', 'komu', 'poznámka', 'EAN']);
    $st = $pdo->prepare("
      SELECT i.sold_at, b.title, b.id as box_id, p.name, i.qty, i.sold_price, i.sold_where, i.sold_to, i.sold_note, p.barcode
      FROM box_items i
      JOIN products p ON p.id = i.product_id
      JOIN boxes b ON b.id = i.box_id
      WHERE $where
      ORDER BY i.sold_at DESC
    ");
    $st->execute($params);
    while ($r = $st->fetch(PDO::FETCH_ASSOC)) {
      $boxLabel = trim(($r['title'] ?? '') ?: ($r['box_id'] ?? ''));
      fputcsv($out, [
        $r['sold_at'],
        $boxLabel,
        $r['name'],
        (int)$r['qty'],
        (float)($r['sold_price'] ?? 0),
        (string)($r['sold_where'] ?? ''),
        (string)($r['sold_to'] ?? ''),
        (string)($r['sold_note'] ?? ''),
        (string)($r['barcode'] ?? ''),
      ]);
    }
  } else {
    $show = $_GET['show'] ?? 'unsold'; // unsold | sold | all
    $where = "i.box_id = ?"; $params = [$boxId];
    if ($show === 'unsold') $where .= " AND i.sold=0";
    if ($show === 'sold')   $where .= " AND i.sold=1";
    fputcsv($out, ['krabice', 'produkt', 'množství', 'cena', 'stav', 'prodejní cena', 'kde', 'komu', 'EAN']);
    $st = $pdo->prepare("
      SELECT b.title, b.id as box_id, p.name, i.qty, i.price, i.sold, i.sold_price, i.sold_where, i.sold_to, p.barcode
      FROM box_items i
      JOIN products p ON p.id = i.product_id
      JOIN boxes b ON b.id = i.box_id
      WHERE $where
      ORDER BY i.sold ASC, p.name COLLATE NOCASE ASC
    ");
    $st->execute($params);
    while ($r = $st->fetch(PDO::FETCH_ASSOC)) {
      $boxLabel = trim(($r['title'] ?? '') ?: ($r['box_id'] ?? ''));
      fputcsv($out, [
        $boxLabel,
        $r['name'],
        (int)$r['qty'],
        (float)($r['price'] ?? 0),
        ((int)$r['sold']===1 ? 'PRODÁNO' : 'NEPRODÁNO'),
        (float)($r['sold_price'] ?? 0),
        (string)($r['sold_where'] ?? ''),
        (string)($r['sold_to'] ?? ''),
        (string)($r['barcode'] ?? ''),
      ]);
    }
  }
  fclose($out);
  exit;
}

render_header('Admin · Export');
?>
<div class="header">
  <div class="brand"><?=h(cfg()['app_name'])?> · Admin</div>
  <div class="footerlinks">
    <a class="btn" href="<?=h(base_url('/admin/dashboard.php'))?>">Přehled</a>
  </div>
</div>

<div class="card">
  <h1 class="h1">Export (CSV)</h1>

  <div class="hr"></div>

  <h2 class="h2">Prodané položky</h2>
  <p class="small">Export všech prodaných položek (volitelně filtr podle data). CSV je kompatibilní s Excelem.</p>
  <form method="get" class="row">
    <input type="hidden" name="mode" value="sold">
    <div class="col">
      <label>Od (YYYY-MM-DD)</label>
      <input class="input" name="from" placeholder="2026-01-01">
    </div>
    <div class="col">
      <label>Do (YYYY-MM-DD)</label>
      <input class="input" name="to" placeholder="2026-01-31">
    </div>
    <div class="col" style="display:flex;align-items:flex-end">
      <button class="btn primary" name="download" value="1" style="width:100%">Stáhnout CSV</button>
    </div>
  </form>

  <div class="hr"></div>

  <h2 class="h2">Obsah konkrétní krabice</h2>
  <p class="small">Export obsahu jedné krabice (neprodané/prodané/vše).</p>
  <form method="get" class="row">
    <input type="hidden" name="mode" value="box">
    <div class="col">
      <label>Krabice</label>
      <select class="input" name="box">
        <?php foreach($pdo->query("SELECT id, COALESCE(NULLIF(title,''), id) AS label FROM boxes ORDER BY created_at DESC")->fetchAll(PDO::FETCH_ASSOC) as $b): ?>
          <option value="<?=h($b['id'])?>" <?= $boxId===$b['id'] ? 'selected' : '' ?>><?=h($b['label'])?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col">
      <label>Režim</label>
      <select class="input" name="show">
        <option value="unsold">Neprodané</option>
        <option value="sold">Prodané</option>
        <option value="all">Vše</option>
      </select>
    </div>
    <div class="col" style="display:flex;align-items:flex-end">
      <button class="btn primary" name="download" value="1" style="width:100%">Stáhnout CSV</button>
    </div>
  </form>
</div>

<?php render_footer(); ?>
