<?php
require_once __DIR__ . '/../lib/layout.php';
require_once __DIR__ . '/../lib/auth.php';
require_admin();
$pdo = db();

$boxId = trim($_GET['box'] ?? '');
if (!$boxId) { header('Location: ' . base_url('/admin/dashboard.php')); exit; }

$boxStmt = $pdo->prepare('SELECT * FROM boxes WHERE id = ?');
$boxStmt->execute([$boxId]);
$box = $boxStmt->fetch(PDO::FETCH_ASSOC);

$allBoxes = $pdo->query("SELECT id, COALESCE(NULLIF(title,''), id) AS label FROM boxes ORDER BY created_at DESC")->fetchAll(PDO::FETCH_ASSOC);

if (!$box) { header('Location: ' . base_url('/admin/dashboard.php')); exit; }

$msg = '';
$err = '';

// Vyhledávání & filtry
$q = trim($_GET['q'] ?? '');
$filter_no_photo = !empty($_GET['no_photo']);
$filter_price_zero = !empty($_GET['price_zero']);
$filter_adv = $_GET['adv'] ?? ''; // bazos|sbazar|aukro|other


if ($_SERVER['REQUEST_METHOD']==='POST') {
  $action = $_POST['action'] ?? '';
  if ($action === 'add_barcode') {
    $barcode = trim($_POST['barcode'] ?? '');
    $qty = (int)($_POST['qty'] ?? 1);
    if ($qty < 1) $qty = 1;
    $price = (float)str_replace(',', '.', ($_POST['price'] ?? '0'));
    $adv_bazos = !empty($_POST['adv_bazos']) ? 1 : 0;
    $adv_sbazar = !empty($_POST['adv_sbazar']) ? 1 : 0;
    $adv_aukro = !empty($_POST['adv_aukro']) ? 1 : 0;
    $adv_other = !empty($_POST['adv_other']) ? 1 : 0;

    if (!$barcode) { $err='Zadej čárový kód.'; }
    else {
      $p = $pdo->prepare('SELECT * FROM products WHERE barcode = ?');
      $p->execute([$barcode]);
      $prod = $p->fetch(PDO::FETCH_ASSOC);
      if (!$prod) {
        header('Location: ' . base_url('/admin/product_edit.php?new=1&barcode=' . urlencode($barcode) . '&box=' . urlencode($boxId)));
        exit;
      }
      // upsert item for this product in box (only for unsold items)
      $it = $pdo->prepare('SELECT * FROM box_items WHERE box_id = ? AND product_id = ? AND sold = 0');
      $it->execute([$boxId, $prod['id']]);
      $item = $it->fetch(PDO::FETCH_ASSOC);
      if ($item) {
        $newQty = (int)$item['qty'] + $qty;
        $newPrice = $price > 0 ? $price : (float)$item['price'];
        $pdo->prepare('UPDATE box_items SET qty=?, price=?, adv_bazos=?, adv_sbazar=?, adv_aukro=?, adv_other=? WHERE id=?')
            ->execute([$newQty, $newPrice, $adv_bazos, $adv_sbazar, $adv_aukro, $adv_other, $item['id']]);
      } else {
        $usePrice = $price > 0 ? $price : (float)$prod['default_price'];
        $pdo->prepare('INSERT INTO box_items(box_id, product_id, qty, price, adv_bazos, adv_sbazar, adv_aukro, adv_other) VALUES(?,?,?,?,?,?,?,?)')
            ->execute([$boxId, $prod['id'], $qty, $usePrice, $adv_bazos, $adv_sbazar, $adv_aukro, $adv_other]);
      }
      $msg = 'Přidáno: ' . $prod['name'];
    }
  } elseif ($action === 'update_item') {
    $id = (int)($_POST['item_id'] ?? 0);
    $qty = (int)($_POST['qty'] ?? 1); if ($qty < 1) $qty = 1;
    $price = (float)str_replace(',', '.', ($_POST['price'] ?? '0'));
    $adv_bazos = !empty($_POST['adv_bazos']) ? 1 : 0;
    $adv_sbazar = !empty($_POST['adv_sbazar']) ? 1 : 0;
    $adv_aukro = !empty($_POST['adv_aukro']) ? 1 : 0;
    $adv_other = !empty($_POST['adv_other']) ? 1 : 0;
    $pdo->prepare('UPDATE box_items SET qty=?, price=?, adv_bazos=?, adv_sbazar=?, adv_aukro=?, adv_other=? WHERE id=? AND box_id=?')
        ->execute([$qty,$price,$adv_bazos,$adv_sbazar,$adv_aukro,$adv_other,$id,$boxId]);
    $msg='Uloženo.';
  } elseif ($action === 'mark_sold') {
    $id = (int)($_POST['item_id'] ?? 0);
    $sold_price = (float)str_replace(',', '.', ($_POST['sold_price'] ?? '0'));
    $sold_where = trim($_POST['sold_where'] ?? '');
    $sold_to = trim($_POST['sold_to'] ?? '');
    $sold_note = trim($_POST['sold_note'] ?? '');
    $pdo->prepare('UPDATE box_items SET sold=1, sold_price=?, sold_where=?, sold_to=?, sold_note=?, sold_at=CURRENT_TIMESTAMP WHERE id=? AND box_id=?')
        ->execute([$sold_price,$sold_where,$sold_to,$sold_note,$id,$boxId]);
    $msg='Označeno jako prodáno.';
  } elseif ($action === 'update_sold') {
    $id = (int)($_POST['item_id'] ?? 0);
    $sold_price = (float)str_replace(',', '.', ($_POST['sold_price'] ?? '0'));
    $sold_where = trim($_POST['sold_where'] ?? '');
    $sold_to = trim($_POST['sold_to'] ?? '');
    $sold_note = trim($_POST['sold_note'] ?? '');
    $pdo->prepare('UPDATE box_items SET sold_price=?, sold_where=?, sold_to=?, sold_note=? WHERE id=? AND box_id=? AND sold=1')
        ->execute([$sold_price,$sold_where,$sold_to,$sold_note,$id,$boxId]);
    $msg='Prodané údaje uloženy.';
  } elseif ($action === 'move_item') {
    $id = (int)($_POST['item_id'] ?? 0);
    $target = trim($_POST['target_box'] ?? '');
    if ($target && $target !== $boxId) {
      $pdo->prepare('UPDATE box_items SET box_id=? WHERE id=? AND box_id=? AND sold=0')->execute([$target,$id,$boxId]);
      $msg='Položka přesunuta.';
    }
  } elseif ($action === 'mark_unsold') {
    $id = (int)($_POST['item_id'] ?? 0);
    $pdo->prepare('UPDATE box_items SET sold=0, sold_price=NULL, sold_at=NULL WHERE id=? AND box_id=?')
        ->execute([$id,$boxId]);
    $msg='Vráceno do neprodaných.';
  } elseif ($action === 'delete_item') {
    $id = (int)($_POST['item_id'] ?? 0);
    $pdo->prepare('DELETE FROM box_items WHERE id=? AND box_id=?')->execute([$id,$boxId]);
    $msg='Smazáno.';

  } elseif ($action === 'upload_attachment') {
    $id = (int)($_POST['item_id'] ?? 0);
    if ($id && !empty($_FILES['files']['name']) && is_array($_FILES['files']['name'])) {
      for ($i=0; $i<count($_FILES['files']['name']); $i++) {
        if (empty($_FILES['files']['name'][$i])) continue;
        if (!is_uploaded_file($_FILES['files']['tmp_name'][$i])) continue;
        $ext = strtolower(pathinfo($_FILES['files']['name'][$i], PATHINFO_EXTENSION));
        if (!in_array($ext, ['jpg','jpeg','png','webp'])) $ext='jpg';
        $fn = 'uploads/sold_' . date('Ymd_His') . '_' . bin2hex(random_bytes(4)) . '.' . $ext;
        $dest = __DIR__ . '/../' . $fn;
        if (move_uploaded_file($_FILES['files']['tmp_name'][$i], $dest)) {
          $pdo->prepare('INSERT INTO item_attachments(item_id, path) VALUES(?,?)')->execute([$id, $fn]);
        }
      }
      $msg='Přílohy nahrány.';
    }
  } elseif ($action === 'delete_attachment') {
    $attId = (int)($_POST['att_id'] ?? 0);
    $itemId = (int)($_POST['item_id'] ?? 0);
    if ($attId && $itemId) {
      $st = $pdo->prepare('SELECT path FROM item_attachments WHERE id=? AND item_id=?');
      $st->execute([$attId, $itemId]);
      $path = (string)$st->fetchColumn();
      if ($path && file_exists(__DIR__ . '/../' . $path)) @unlink(__DIR__ . '/../' . $path);
      $pdo->prepare('DELETE FROM item_attachments WHERE id=? AND item_id=?')->execute([$attId, $itemId]);
      $msg='Příloha smazána.';
    }

  } elseif ($action === 'update_box') {
    $title = trim($_POST['title'] ?? '');
    $pdo->prepare('UPDATE boxes SET title=? WHERE id=?')->execute([$title,$boxId]);
    $msg='Název uložen.';
  }
}

// fetch items
$unsold = $pdo->prepare("
  SELECT i.*, p.barcode, p.name, p.photo
  FROM box_items i
  JOIN products p ON p.id = i.product_id
  WHERE i.box_id=? AND i.sold=0
  ORDER BY p.name COLLATE NOCASE ASC
");
$unsold->execute([$boxId]);
$unsoldItems = $unsold->fetchAll(PDO::FETCH_ASSOC);

$sold = $pdo->prepare("
  SELECT i.*, p.barcode, p.name, p.photo
  FROM box_items i
  JOIN products p ON p.id = i.product_id
  WHERE i.box_id=? AND i.sold=1
  ORDER BY i.sold_at DESC
");
$sold->execute([$boxId]);
$soldItems = $sold->fetchAll(PDO::FETCH_ASSOC);

$totalSold = 0;
foreach ($soldItems as $it) $totalSold += (float)($it['sold_price'] ?? 0);

render_header('Admin · Krabice', '<script src="'.h(base_url('/assets/scan.js')).'"></script><script src="'.h(base_url('/assets/qrcode.min.js')).'"></script>');
?>
<div class="header">
  <div>
    <div class="brand"><?=h(cfg()['app_name'])?> · Admin</div>
    <div class="small">Krabice: <b><?=h($box['title'] ?: $box['id'])?></b></div>
  </div>
  <div class="footerlinks">
    <a class="btn" href="<?=h(base_url('/admin/dashboard.php'))?>">Přehled</a>
    <a class="btn" href="<?=h(base_url('/box.php?box=' . urlencode($boxId)))?>">Veřejný náhled</a>
    <a class="btn" href="<?=h(base_url('/admin/print_qr.php?box=' . urlencode($boxId)))?>">Tisk QR</a>
    <a class="btn" href="<?=h(base_url('/admin/export.php?mode=box&box=' . urlencode($boxId)))?>">Export CSV</a>
  </div>
</div>

<div class="card">
  <h2 class="h2">Vyhledávání & filtry</h2>
  <form method="get" class="row">
    <input type="hidden" name="box" value="<?=h($boxId)?>">
    <div class="col">
      <label for="q">Hledat (název/EAN/poznámka)</label>
      <input class="input" id="q" name="q" value="<?=h($q)?>" placeholder="např. nabíječka / 859..." autocomplete="off">
    </div>
    <div class="col">
      <label>Rychlé filtry (neprodané)</label>
      <div class="row">
        <div class="col"><label class="pill"><input type="checkbox" name="no_photo" value="1" <?= $filter_no_photo?'checked':'' ?>> Bez fotky</label></div>
        <div class="col"><label class="pill"><input type="checkbox" name="price_zero" value="1" <?= $filter_price_zero?'checked':'' ?>> Cena 0</label></div>
      </div>
      <div class="row" style="margin-top:6px">
        <div class="col">
          <select class="input" name="adv">
            <option value="" <?= $filter_adv===''?'selected':'' ?>>Inzerce: vše</option>
            <option value="bazos" <?= $filter_adv==='bazos'?'selected':'' ?>>Jen Bazoš</option>
            <option value="sbazar" <?= $filter_adv==='sbazar'?'selected':'' ?>>Jen Sbazar</option>
            <option value="aukro" <?= $filter_adv==='aukro'?'selected':'' ?>>Jen Aukro</option>
            <option value="other" <?= $filter_adv==='other'?'selected':'' ?>>Jen Jiné</option>
          </select>
        </div>
      </div>
      <div class="footerlinks" style="margin-top:8px">
        <button class="btn primary" type="submit">Použít</button>
        <?php if($q!=='' || $filter_no_photo || $filter_price_zero || $filter_adv!==''): ?>
          <a class="btn" href="<?=h(base_url('/admin/box.php?box=' . urlencode($boxId)))?>">Zrušit</a>
        <?php endif; ?>
      </div>
    </div>
  </form>
</div>

<div class="card">
  <?php if($msg): ?><div class="notice" style="border-color:rgba(134,239,172,.35);color:#fff"><?=h($msg)?></div><?php endif; ?>
  <?php if($err): ?><div class="notice" style="border-color:rgba(251,113,133,.35);color:#fff"><?=h($err)?></div><?php endif; ?>

  <form method="post" class="row">
    <input type="hidden" name="action" value="update_box">
    <div class="col">
      <label for="title">Název krabice</label>
      <input class="input" id="title" name="title" value="<?=h($box['title'])?>" placeholder="např. Krabice A / regál 2">
    </div>
    <div class="col" style="display:flex;align-items:flex-end">
      <button class="btn primary" style="width:100%" type="submit">Uložit</button>
    </div>
  </form>

  <div class="hr"></div>

  <h2 class="h2">Přidat produkt do krabice</h2>
  <p class="small">Můžeš zadat kód ručně, použít fyzický skener (chová se jako klávesnice), nebo zkusit kamerové snímání.</p>

  <div class="row">
    <div class="col">
      <form method="post" id="addForm">
        <input type="hidden" name="action" value="add_barcode">
        <label for="barcode">Čárový kód</label>
        <input class="input" id="barcode" name="barcode" placeholder="EAN / CODE128..." inputmode="numeric" autocomplete="off">
        <div class="row">
          <div class="col">
            <label for="qty">Množství</label>
            <input class="input" id="qty" name="qty" type="number" min="1" value="1">
          </div>
          <div class="col">
            <label for="price">Cena (Kč) — volitelně</label>
            <input class="input" id="price" name="price" type="number" step="0.01" min="0" placeholder="pokud prázdné, použije se výchozí z produktu">
          </div>
        </div>

        <label>Inzerce</label>
        <div class="row">
          <div class="col"><label class="pill"><input type="checkbox" name="adv_bazos" value="1"> Bazoš</label></div>
          <div class="col"><label class="pill"><input type="checkbox" name="adv_sbazar" value="1"> Sbazar</label></div>
          <div class="col"><label class="pill"><input type="checkbox" name="adv_aukro" value="1"> Aukro</label></div>
          <div class="col"><label class="pill"><input type="checkbox" name="adv_other" value="1"> Jiné</label></div>
        </div>

        <div class="footerlinks">
          <button class="btn primary" type="submit">Přidat</button>
          <button class="btn" type="button" id="startScanBtn">Sken kamerou</button>
        </div>
      </form>
    </div>

    <div class="col">
      <div class="videoWrap noPrint" id="videoWrap" style="display:none">
        <video id="video" playsinline></video>
        <div class="scanBox"></div>
        <div class="scanHint">Namíř kameru na čárový kód…</div>
      </div>
      <div class="notice">Tip: Pokud používáš Bluetooth/USB skener, stačí kliknout do pole „Čárový kód“ a skenovat.</div>
    </div>
  </div>

  <script>
    const videoWrap = document.getElementById('videoWrap');
    const videoEl = document.getElementById('video');
    const startBtn = document.getElementById('startScanBtn');
    const barcodeInput = document.getElementById('barcode');

    let scanner = null;
    startBtn.addEventListener('click', async () => {
      try{
        videoWrap.style.display = 'block';
        scanner = await startBarcodeScan(videoEl, (code) => {
          barcodeInput.value = code;
          videoWrap.style.display = 'none';
          document.getElementById('addForm').requestSubmit();
        });
      }catch(e){
        alert('Nepodařilo se spustit skenování: ' + (e?.message || e));
        videoWrap.style.display = 'none';
      }
    });
  </script>

  <script>
    // Auto-uložení polí pro přidávání položek (když se mobil uspí / zavře)
    (function(){
      const key = 'qrbox_addform_draft_' + <?=json_encode($boxId)?>;
      const ids = ['barcode','qty','price'];
      const adv = ['adv_bazos','adv_sbazar','adv_aukro','adv_other'];
      function save(){
        const data = {};
        for(const id of ids){
          const el=document.getElementById(id);
          if(el) data[id]=el.value;
        }
        for(const n of adv){
          const el=document.querySelector('input[name="'+n+'"]');
          if(el) data[n]=el.checked?1:0;
        }
        localStorage.setItem(key, JSON.stringify(data));
      }
      function load(){
        try{
          const raw=localStorage.getItem(key);
          if(!raw) return;
          const data=JSON.parse(raw);
          for(const id of ids){
            const el=document.getElementById(id);
            if(el && el.value==='') el.value = data[id] ?? el.value;
          }
          for(const n of adv){
            const el=document.querySelector('input[name="'+n+'"]');
            if(el && data[n]!==undefined) el.checked = !!data[n];
          }
        }catch(e){}
      }
      load();
      for(const id of ids){
        const el=document.getElementById(id);
        if(el) el.addEventListener('input', save);
      }
      for(const n of adv){
        const el=document.querySelector('input[name="'+n+'"]');
        if(el) el.addEventListener('change', save);
      }
      document.addEventListener('visibilitychange', ()=>{ if(document.hidden) save(); });
      window.addEventListener('beforeunload', save);
    })();
  </script>

</div>

<div class="card" style="margin-top:14px">
  <h2 class="h2">Neprodané položky</h2>
  <?php if(!$unsoldItems): ?>
    <div class="notice">Zatím žádné neprodané položky.</div>
  <?php else: ?>
    <?php foreach($unsoldItems as $it): ?>
      <div class="itemcard">
        <div class="thumb">
          <?php if (!empty($it['photo']) && file_exists(__DIR__ . '/../' . $it['photo'])): ?>
            <img alt="" src="<?=h(base_url('/' . $it['photo']))?>">
          <?php else: ?><span class="small">bez fotky</span><?php endif; ?>
        </div>
        <div class="meta">
          <div class="title"><?=h($it['name'])?></div>
          <div class="line">
            <span class="pill">Množství: <b><?= (int)$it['qty'] ?></b></span>
            <span class="pill">Cena: <b><?=number_format((float)$it['price'],0,',',' ')?> Kč</b></span>
            <span class="small">Kód: <?=h($it['barcode'])?></span>
            <?php $attsStmt = $pdo->prepare('SELECT * FROM item_attachments WHERE item_id=? ORDER BY id DESC'); $attsStmt->execute([(int)$it['id']]); $atts = $attsStmt->fetchAll(PDO::FETCH_ASSOC); ?>
          </div>
          <?php if(!empty($atts)): ?>
            <div class="line" style="margin-top:8px;gap:8px;align-items:center">
              <?php foreach($atts as $a): ?>
                <div style="display:flex;flex-direction:column;gap:6px;align-items:center">
                  <div class="thumb" style="width:56px;height:56px"><img alt="" src="<?=h(base_url('/' . $a['path']))?>"></div>
                  <form method="post" onsubmit="return confirm('Smazat přílohu?')">
                    <input type="hidden" name="action" value="delete_attachment">
                    <input type="hidden" name="item_id" value="<?= (int)$it['id'] ?>">
                    <input type="hidden" name="att_id" value="<?= (int)$a['id'] ?>">
                    <button class="btn danger" type="submit" style="padding:6px 10px">Smazat</button>
                  </form>
                </div>
              <?php endforeach; ?>
            </div>
          <?php endif; ?>

          <div class="line" style="margin-top:6px">
            <?php if ((int)$it['adv_bazos']): ?><span class="badge ok">Bazoš</span><?php endif; ?>
            <?php if ((int)$it['adv_sbazar']): ?><span class="badge ok">Sbazar</span><?php endif; ?>
            <?php if ((int)$it['adv_aukro']): ?><span class="badge ok">Aukro</span><?php endif; ?>
            <?php if ((int)$it['adv_other']): ?><span class="badge ok">Jiné</span><?php endif; ?>
            <a class="btn" href="<?=h(base_url('/admin/product_edit.php?id='.(int)$it['product_id'].'&box='.urlencode($boxId)))?>">Edit produkt</a>
            <form method="post" style="display:inline">
              <input type="hidden" name="action" value="move_item">
              <input type="hidden" name="item_id" value="<?= (int)$it['id'] ?>">
              <select name="target_box" class="input" style="width:auto;display:inline-block;padding:8px 10px" onchange="this.form.requestSubmit()">
                <option value="">Přesunout do…</option>
                <?php foreach($allBoxes as $b): if($b['id']===$boxId) continue; ?>
                  <option value="<?=h($b['id'])?>"><?=h($b['label'])?></option>
                <?php endforeach; ?>
              </select>
            </form>
          </div>

          <details style="margin-top:8px">
            <summary class="small">Upravit / označit prodáno</summary>
            <div class="row" style="margin-top:8px">
              <div class="col">
                <form method="post">
                  <input type="hidden" name="action" value="update_item">
                  <input type="hidden" name="item_id" value="<?= (int)$it['id'] ?>">
                  <label>Množství</label>
                  <input class="input" type="number" min="1" name="qty" value="<?= (int)$it['qty'] ?>">
                  <label>Cena (Kč)</label>
                  <input class="input" type="number" step="0.01" min="0" name="price" value="<?=h($it['price'])?>">
                  <label>Inzerce</label>
                  <div class="row">
                    <div class="col"><label class="pill"><input type="checkbox" name="adv_bazos" value="1" <?= (int)$it['adv_bazos']?'checked':'' ?>> Bazoš</label></div>
                    <div class="col"><label class="pill"><input type="checkbox" name="adv_sbazar" value="1" <?= (int)$it['adv_sbazar']?'checked':'' ?>> Sbazar</label></div>
                    <div class="col"><label class="pill"><input type="checkbox" name="adv_aukro" value="1" <?= (int)$it['adv_aukro']?'checked':'' ?>> Aukro</label></div>
                    <div class="col"><label class="pill"><input type="checkbox" name="adv_other" value="1" <?= (int)$it['adv_other']?'checked':'' ?>> Jiné</label></div>
                  </div>
                  <div class="footerlinks">
                    <button class="btn primary" type="submit">Uložit</button>
                  </div>
                </form>
              </div>
              <div class="col">
                <form method="post">
                  <input type="hidden" name="action" value="mark_sold">
                  <input type="hidden" name="item_id" value="<?= (int)$it['id'] ?>">
                  <label>Prodejní cena (Kč)</label>
                  <input class="input" type="number" step="0.01" min="0" name="sold_price" placeholder="např. 499">
                  <label>Kde prodáno (platforma)</label>
                  <input class="input" name="sold_where" value="<?=h($it['sold_where'] ?? '')?>" placeholder="např. Bazoš / Aukro / osobně">
                  <label>Komu (kupující)</label>
                  <input class="input" name="sold_to" value="<?=h($it['sold_to'] ?? '')?>" placeholder="např. Jan N.">
                  <label>Poznámka</label>
                  <textarea class="input" name="sold_note" rows="2" placeholder="např. poslání Zásilkovnou"></textarea>
                  <div class="footerlinks">
                    <button class="btn ok" type="submit">Označit prodáno</button>
                  </div>
                </form>

                <form method="post" onsubmit="return confirm('Opravdu smazat položku z krabice?')">
                  <input type="hidden" name="action" value="delete_item">
                  <input type="hidden" name="item_id" value="<?= (int)$it['id'] ?>">
                  <div class="footerlinks">
                    <button class="btn danger" type="submit">Smazat</button>
                  </div>
                </form>
              </div>
            </div>
          </details>
        </div>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>
</div>

<div class="card" style="margin-top:14px">
  <h2 class="h2">Prodané položky</h2>
  <div class="pill">Celkem za prodej: <b><?=number_format((float)$totalSold,0,',',' ')?> Kč</b></div>
  <?php if(!$soldItems): ?>
    <div class="notice" style="margin-top:10px">Zatím nic prodaného.</div>
  <?php else: ?>
    <?php foreach($soldItems as $it): $profit = null; if (!empty($it['buy_price']) && (float)$it['buy_price']>0) { $profit = (float)($it['sold_price']??0) - ((float)$it['buy_price'] * (int)$it['qty']); } ?>
      <div class="itemcard">
        <div class="thumb">
          <?php if (!empty($it['photo']) && file_exists(__DIR__ . '/../' . $it['photo'])): ?>
            <img alt="" src="<?=h(base_url('/' . $it['photo']))?>">
          <?php else: ?><span class="small">bez fotky</span><?php endif; ?>
        </div>
        <div class="meta">
          <div class="title"><?=h($it['name'])?> <span class="badge danger">PRODÁNO</span></div>
          <div class="line">
            <span class="pill">Množství: <b><?= (int)$it['qty'] ?></b></span>
            <span class="pill">Prodej: <b><?=number_format((float)($it['sold_price']??0),0,',',' ')?> Kč</b></span>
            <?php if($profit !== null): ?><span class="pill">Zisk: <b><?=number_format((float)$profit,0,',',' ')?> Kč</b></span><?php endif; ?>
            <span class="small">Kód: <?=h($it['barcode'])?></span>
            <?php $attsStmt = $pdo->prepare('SELECT * FROM item_attachments WHERE item_id=? ORDER BY id DESC'); $attsStmt->execute([(int)$it['id']]); $atts = $attsStmt->fetchAll(PDO::FETCH_ASSOC); ?>
          </div>
          <div class="line" style="margin-top:6px">
            <form method="post">
              <input type="hidden" name="action" value="mark_unsold">
              <input type="hidden" name="item_id" value="<?= (int)$it['id'] ?>">
              <button class="btn" type="submit">Vrátit do neprodaných</button>
            </form>

            <details style="margin-top:10px">
              <summary class="small">Prodejní karta</summary>

              <form method="post" style="margin-top:10px">
                <input type="hidden" name="action" value="update_sold">
                <input type="hidden" name="item_id" value="<?= (int)$it['id'] ?>">
                <label>Prodejní cena (Kč)</label>
                <input class="input" type="number" step="0.01" min="0" name="sold_price" value="<?=h($it['sold_price'] ?? 0)?>">
                <label>Kde prodáno (platforma)</label>
                <input class="input" name="sold_where" value="<?=h($it['sold_where'] ?? '')?>" placeholder="např. Bazoš / Aukro / osobně">
                <label>Komu (kupující)</label>
                <input class="input" name="sold_to" value="<?=h($it['sold_to'] ?? '')?>" placeholder="např. Jan N.">
                <label>Poznámka</label>
                <textarea class="input" name="sold_note" rows="2" placeholder="např. poslání, rezervace, ..."><?=h($it['sold_note'] ?? '')?></textarea>
                <div class="footerlinks">
                  <button class="btn primary" type="submit">Uložit údaje</button>
                </div>
              </form>

              <form method="post" enctype="multipart/form-data" style="margin-top:10px">
                <input type="hidden" name="action" value="upload_attachment">
                <input type="hidden" name="item_id" value="<?= (int)$it['id'] ?>">
                <label>Přílohy (chat / doklad) — můžeš přidat více</label>
                <input class="input" type="file" name="files[]" accept="image/*" multiple>
                <div class="footerlinks">
                  <button class="btn" type="submit">Nahrát přílohy</button>
                </div>
              </form>
            </details>

          </div>
        </div>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>
</div>

<?php render_footer(); ?>
