<?php
require_once __DIR__ . '/layout.php';

function ensure_session() : void {
  if (session_status() !== PHP_SESSION_ACTIVE) {
    session_set_cookie_params([
      'lifetime' => 0,
      'path' => '/',
      'httponly' => true,
      'samesite' => 'Lax',
    ]);
    @session_start();
  }
}

function is_admin() : bool {
  ensure_session();
  return !empty($_SESSION['is_admin']);
}

function set_admin(bool $v) : void {
  ensure_session();
  $_SESSION['is_admin'] = $v ? 1 : 0;
}

function logout_admin() : void {
  ensure_session();
  $_SESSION = [];
  if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
      $params["path"], $params["domain"] ?? '', $params["secure"] ?? false, $params["httponly"] ?? true
    );
  }
  @session_destroy();
}

function check_pin(string $pin) : bool {
  $cfg = cfg();
  $expected = (string)($cfg['admin_pin'] ?? '9725');
  return hash_equals($expected, trim($pin));
}

function check_password(string $password) : bool {
  $cfg = cfg();
  $expected = (string)($cfg['admin_password'] ?? 'admin');
  return hash_equals($expected, trim($password));
}

function require_admin() : void {
  if (!is_admin()) {
    header('Location: ' . base_url('/admin/login.php'));
    exit;
  }
}
