<?php
require_once __DIR__ . '/../lib/layout.php';
require_once __DIR__ . '/../lib/auth.php';
require_admin();
$pdo = db();

$boxId = trim($_GET['box'] ?? '');
if (!$boxId) { header('Location: ' . base_url('/admin/dashboard.php')); exit; }

$boxStmt = $pdo->prepare('SELECT * FROM boxes WHERE id=?');
$boxStmt->execute([$boxId]);
$box = $boxStmt->fetch(PDO::FETCH_ASSOC);
if (!$box) { header('Location: ' . base_url('/admin/dashboard.php')); exit; }

$publicUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ? 'https' : 'http')
  . '://' . ($_SERVER['HTTP_HOST'] ?? 'localhost')
  . (cfg()['base_url'] ?? '')
  . '/box.php?box=' . urlencode($boxId);

render_header('Tisk QR', '<script src="'.h(base_url('/assets/qrcode.min.js')).'"></script>');
?>
<div class="card">
  <div class="header noPrint">
    <div>
      <div class="brand"><?=h(cfg()['app_name'])?> · Admin</div>
      <div class="small">Tisk QR · Krabice: <b><?=h($box['title'] ?: $box['id'])?></b></div>
    </div>
    <div class="footerlinks">
      <a class="btn" href="<?=h(base_url('/admin/box.php?box=' . urlencode($boxId)))?>">Zpět</a>
      <button class="btn primary" onclick="window.print()">Tisknout</button>
    </div>
  </div>

  <h1 class="h1">QR štítek</h1>
  <p class="small">QR vede na veřejný náhled obsahu krabice. Pokud aplikaci přesuneš na jinou doménu, QR znovu vytiskni.</p>

  <div class="row">
    <div class="col">
      <div class="card" style="background:#fff;color:#000;border-color:#ddd">
        <div style="display:flex;gap:14px;align-items:center">
          <canvas id="qr"></canvas>
          <div>
            <div style="font-size:18px;font-weight:900"><?=h($box['title'] ?: 'Krabice')?></div>
            <div style="font-size:12px;color:#333;margin-top:4px">ID: <?=h($boxId)?></div>
            <div style="font-size:12px;color:#333;margin-top:6px">Odkaz: <?=h($publicUrl)?></div>
          </div>
        </div>
      </div>
    </div>
    <div class="col">
      <div class="notice">
        Tip: Pro rychlé otevření může QR obsahovat odkaz. Veřejná stránka pak ukáže fotku, množství a cenu.
      </div>
    </div>
  </div>

  <script>
    const url = <?=json_encode($publicUrl)?>;
    QRBoxQR.toCanvas(url, document.getElementById('qr'), 8);
  </script>
</div>
<?php render_footer(); ?>
