<?php
require_once __DIR__ . '/db.php';
session_start();

function is_admin() : bool {
  return !empty($_SESSION['admin_logged_in']);
}
function require_admin() {
  if (!is_admin()) {
    header('Location: ' . base_url('/admin/login.php'));
    exit;
  }
}
function login($password) : bool {
  $cfg = cfg();
  if (hash_equals($cfg['admin_password'], (string)$password)) {
    $_SESSION['admin_logged_in'] = 1;
    return true;
  }
  return false;
}
function logout() {
  $_SESSION = [];
  if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
      $params["path"], $params["domain"],
      $params["secure"], $params["httponly"]
    );
  }
  session_destroy();
}
