<?php
require_once __DIR__ . '/../lib/layout.php';
require_once __DIR__ . '/../lib/auth.php';
require_admin();
$pdo = db();

$uploadDir = cfg()['upload_dir'];
if (!is_dir($uploadDir)) mkdir($uploadDir, 0775, true);

$new = !empty($_GET['new']);
$barcode = trim($_GET['barcode'] ?? '');
$boxId = trim($_GET['box'] ?? '');
$id = (int)($_GET['id'] ?? 0);

$product = null;
$photos = [];

function load_product_and_photos(PDO $pdo, $id, $barcode) {
  $product = null;
  $photos = [];
  if ($id) {
    $st = $pdo->prepare('SELECT * FROM products WHERE id=?');
    $st->execute([$id]);
    $product = $st->fetch(PDO::FETCH_ASSOC);
  } elseif ($barcode) {
    $st = $pdo->prepare('SELECT * FROM products WHERE barcode=?');
    $st->execute([$barcode]);
    $product = $st->fetch(PDO::FETCH_ASSOC);
  }
  if ($product) {
    $ph = $pdo->prepare('SELECT * FROM product_photos WHERE product_id=? ORDER BY sort_order ASC, id ASC');
    $ph->execute([(int)$product['id']]);
    $photos = $ph->fetchAll(PDO::FETCH_ASSOC);
  }
  return [$product, $photos];
}

[$product, $photos] = load_product_and_photos($pdo, $id, $barcode);

$err=''; $msg='';

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $action = $_POST['action'] ?? '';

  if ($action==='save_product') {
    $pid = (int)($_POST['id'] ?? 0);
    $barcode = trim($_POST['barcode'] ?? '');
    $name = trim($_POST['name'] ?? '');
    $default_price = (float)str_replace(',', '.', ($_POST['default_price'] ?? '0'));
    $buy_price = (float)str_replace(',', '.', ($_POST['buy_price'] ?? '0'));
    $notes = trim($_POST['notes'] ?? '');

    if (!$barcode) $err = 'Chybí čárový kód.';
    elseif (!$name) $err = 'Chybí název.';
    else {
      $photoPath = trim($_POST['photo_current'] ?? ''); // hlavní fotka
      $newPhotoPaths = [];

      // multi upload (photos[])
      if (!empty($_FILES['photos']['name']) && is_array($_FILES['photos']['name'])) {
        for ($i=0; $i<count($_FILES['photos']['name']); $i++) {
          if (empty($_FILES['photos']['name'][$i])) continue;
          if (!is_uploaded_file($_FILES['photos']['tmp_name'][$i])) continue;

          $ext = strtolower(pathinfo($_FILES['photos']['name'][$i], PATHINFO_EXTENSION));
          if (!in_array($ext, ['jpg','jpeg','png','webp'])) $ext='jpg';

          $fn = 'uploads/' . date('Ymd_His') . '_' . bin2hex(random_bytes(4)) . '.' . $ext;
          $dest = __DIR__ . '/../' . $fn;

          if (!move_uploaded_file($_FILES['photos']['tmp_name'][$i], $dest)) {
            $err = 'Nepodařilo se uložit některou fotku.';
            break;
          } else {
            $newPhotoPaths[] = $fn;
          }
        }
      }

      if (!$err) {
        if ($pid) {
          $pdo->prepare('UPDATE products SET barcode=?, name=?, photo=?, default_price=?, buy_price=?, notes=? WHERE id=?')
              ->execute([$barcode,$name,$photoPath,$default_price,$buy_price,$notes,$pid]);
          $id = $pid;
          $msg='Uloženo.';
        } else {
          // pokud vzniká nový produkt a jsou nahrané fotky, dej první jako hlavní
          if (!$photoPath && !empty($newPhotoPaths)) $photoPath = $newPhotoPaths[0];
          $pdo->prepare('INSERT INTO products(barcode,name,photo,default_price,buy_price,notes) VALUES(?,?,?,?,?,?)')
              ->execute([$barcode,$name,$photoPath,$default_price,$buy_price,$notes]);
          $id = (int)$pdo->lastInsertId();
          $msg='Produkt vytvořen.';
        }

        // uložit nové fotky do galerie
        if (!empty($newPhotoPaths)) {
          $ord = (int)$pdo->query('SELECT COALESCE(MAX(sort_order),-1) FROM product_photos WHERE product_id='.(int)$id)->fetchColumn();
          foreach ($newPhotoPaths as $p) {
            $ord++;
            $pdo->prepare('INSERT INTO product_photos(product_id, path, sort_order) VALUES(?,?,?)')
                ->execute([(int)$id, (string)$p, (int)$ord]);
          }
          // pokud ještě není hlavní fotka, nastav první
          if (!$photoPath) {
            $photoPath = $newPhotoPaths[0];
            $pdo->prepare('UPDATE products SET photo=? WHERE id=?')->execute([$photoPath, (int)$id]);
          }
        }

        // refresh
        [$product, $photos] = load_product_and_photos($pdo, $id, '');
        // if coming from box add flow
        $nextBox = trim($_POST['next_box'] ?? '');
        if ($nextBox) {
          header('Location: ' . base_url('/admin/box.php?box=' . urlencode($nextBox)));
          exit;
        }
      }
    }
  }

  elseif ($action==='set_primary') {
    $pid = (int)($_POST['id'] ?? 0);
    $photoId = (int)($_POST['photo_id'] ?? 0);
    if ($pid && $photoId) {
      $st = $pdo->prepare('SELECT path FROM product_photos WHERE id=? AND product_id=?');
      $st->execute([$photoId, $pid]);
      $path = (string)$st->fetchColumn();
      if ($path) {
        $pdo->prepare('UPDATE products SET photo=? WHERE id=?')->execute([$path, $pid]);
        $msg='Nastaveno jako hlavní.';
      }
    }
    [$product, $photos] = load_product_and_photos($pdo, $pid, '');
  }

  elseif ($action==='delete_photo_item') {
    $pid=(int)($_POST['id'] ?? 0);
    $photoId=(int)($_POST['photo_id'] ?? 0);
    if ($pid && $photoId) {
      $st=$pdo->prepare('SELECT path FROM product_photos WHERE id=? AND product_id=?');
      $st->execute([$photoId,$pid]);
      $ph=(string)$st->fetchColumn();

      if ($ph && file_exists(__DIR__ . '/../' . $ph)) @unlink(__DIR__ . '/../' . $ph);
      $pdo->prepare('DELETE FROM product_photos WHERE id=? AND product_id=?')->execute([$photoId,$pid]);

      // pokud byla smazaná hlavní, nastav jinou nebo null
      $st=$pdo->prepare('SELECT path FROM product_photos WHERE product_id=? ORDER BY sort_order ASC, id ASC LIMIT 1');
      $st->execute([$pid]);
      $first=(string)$st->fetchColumn();
      $current = (string)$pdo->query('SELECT photo FROM products WHERE id='.(int)$pid)->fetchColumn();
      if ($current === $ph) {
        $pdo->prepare('UPDATE products SET photo=? WHERE id=?')->execute([$first ?: null, $pid]);
      }
      $msg='Fotka smazána.';
    }
    [$product, $photos] = load_product_and_photos($pdo, $pid, '');
  }
}

$title = $new ? 'Nový produkt' : 'Edit produktu';
render_header('Admin · ' . $title);
?>
<div class="header">
  <div class="brand"><?=h(cfg()['app_name'])?> · Admin</div>
  <div class="footerlinks">
    <?php if($boxId): ?><a class="btn" href="<?=h(base_url('/admin/box.php?box=' . urlencode($boxId)))?>">Zpět na krabici</a><?php endif; ?>
    <a class="btn" href="<?=h(base_url('/admin/dashboard.php'))?>">Přehled</a>
  </div>
</div>

<div class="card">
  <h1 class="h1"><?=h($title)?></h1>
  <?php if($msg): ?><div class="notice" style="border-color:rgba(134,239,172,.35);color:#fff"><?=h($msg)?></div><?php endif; ?>
  <?php if($err): ?><div class="notice" style="border-color:rgba(251,113,133,.35);color:#fff"><?=h($err)?></div><?php endif; ?>

  <form method="post" enctype="multipart/form-data" id="productForm">
    <input type="hidden" name="action" value="save_product">
    <input type="hidden" name="id" value="<?=h($product['id'] ?? '')?>">
    <input type="hidden" name="photo_current" value="<?=h($product['photo'] ?? '')?>">
    <input type="hidden" name="next_box" value="<?=h($boxId)?>">

    <label for="barcode">Čárový kód</label>
    <input class="input" id="barcode" name="barcode" value="<?=h($product['barcode'] ?? $barcode)?>">

    <label for="name">Název</label>
    <input class="input" id="name" name="name" value="<?=h($product['name'] ?? '')?>" placeholder="např. Nabíječka USB-C 65W" autofocus>

    <label for="default_price">Výchozí prodejní cena (Kč)</label>
    <input class="input" id="default_price" name="default_price" type="number" step="0.01" min="0" value="<?=h($product['default_price'] ?? '0')?>">

    <label for="buy_price">Nákupní cena (Kč) — volitelné</label>
    <input class="input" id="buy_price" name="buy_price" type="number" step="0.01" min="0" value="<?=h($product['buy_price'] ?? '0')?>">

    <label for="photos">Fotky produktu (můžeš vybrat více)</label>
    <input class="input" id="photos" name="photos[]" type="file" accept="image/*" multiple>

    <label for="notes">Poznámka</label>
    <textarea class="input" id="notes" name="notes" rows="3" placeholder="volitelné"><?=h($product['notes'] ?? '')?></textarea>

    <div class="footerlinks">
      <button class="btn primary" type="submit">Uložit</button>
      <?php if($boxId): ?><a class="btn" href="<?=h(base_url('/admin/box.php?box=' . urlencode($boxId)))?>">Zpět</a><?php endif; ?>
    </div>
  </form>

  <?php if(!empty($product) && !empty($photos)): ?>
    <div class="hr"></div>
    <h2 class="h2">Galerie</h2>
    <p class="small">„Hlavní“ fotka se ukazuje v přehledech (obsah krabice).</p>
    <div class="grid">
      <?php foreach($photos as $ph): ?>
        <div class="itemcard">
          <div class="thumb"><img alt="" src="<?=h(base_url('/' . $ph['path']))?>"></div>
          <div class="meta">
            <div class="small"><?=h($ph['path'])?></div>
            <div class="footerlinks">
              <form method="post" style="display:inline">
                <input type="hidden" name="action" value="set_primary">
                <input type="hidden" name="id" value="<?=h($product['id'])?>">
                <input type="hidden" name="photo_id" value="<?=h($ph['id'])?>">
                <button class="btn <?= ((string)($product['photo'] ?? '') === (string)$ph['path']) ? 'primary' : '' ?>" type="submit">
                  <?= ((string)($product['photo'] ?? '') === (string)$ph['path']) ? 'Hlavní' : 'Nastavit hlavní' ?>
                </button>
              </form>
              <form method="post" style="display:inline" onsubmit="return confirm('Smazat tuto fotku?')">
                <input type="hidden" name="action" value="delete_photo_item">
                <input type="hidden" name="id" value="<?=h($product['id'])?>">
                <input type="hidden" name="photo_id" value="<?=h($ph['id'])?>">
                <button class="btn danger" type="submit">Smazat</button>
              </form>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>
</div>

<script>
  // Auto-uložení rozpracovaného formuláře (např. při vypnutí displeje / zavření)
  (function(){
    const productId = document.querySelector('input[name="id"]').value || 'new';
    const key = 'qrbox_product_draft_' + productId;
    const fields = ['barcode','name','default_price','notes'];

    function save(){
      const data = {};
      for(const id of fields){
        const el = document.getElementById(id);
        if(el) data[id] = el.value;
      }
      localStorage.setItem(key, JSON.stringify(data));
    }
    function load(){
      try{
        const raw = localStorage.getItem(key);
        if(!raw) return;
        const data = JSON.parse(raw);
        for(const id of fields){
          const el = document.getElementById(id);
          if(!el) continue;
          if(el.value === '' || id === 'notes') el.value = (data[id] ?? el.value);
        }
      }catch(e){}
    }

    load();
    for(const id of fields){
      const el = document.getElementById(id);
      if(el) el.addEventListener('input', save);
    }
    document.addEventListener('visibilitychange', ()=>{ if(document.hidden) save(); });
    window.addEventListener('beforeunload', save);
  })();
</script>

<?php render_footer(); ?>
