<?php
require_once __DIR__ . '/lib/layout.php';
$pdo = db();

$boxId = trim($_GET['box'] ?? '');
$show = $_GET['show'] ?? 'unsold'; // unsold | sold | all

render_header('Krabice');

if (!$boxId) {
  echo '<div class="card"><div class="notice">Chybí parametr <b>box</b>.</div><div class="footerlinks"><a class="btn" href="' . h(base_url('/index.php')) . '">Zpět</a></div></div>';
  render_footer(); exit;
}

$box = $pdo->prepare('SELECT * FROM boxes WHERE id = ?');
$box->execute([$boxId]);
$box = $box->fetch(PDO::FETCH_ASSOC);

if (!$box) {
  echo '<div class="card"><h1 class="h1">Krabice nenalezena</h1><p class="small">Kód: ' . h($boxId) . '</p><div class="footerlinks"><a class="btn" href="' . h(base_url('/index.php')) . '">Zpět</a></div></div>';
  render_footer(); exit;
}

$where = "i.box_id = :box_id";
if ($show === 'unsold') $where .= " AND i.sold = 0";
if ($show === 'sold') $where .= " AND i.sold = 1";

$stmt = $pdo->prepare("
  SELECT i.*, p.barcode, p.name, p.photo
  FROM box_items i
  JOIN products p ON p.id = i.product_id
  WHERE $where
  ORDER BY i.sold ASC, p.name COLLATE NOCASE ASC
");
$stmt->execute([':box_id' => $boxId]);
$items = $stmt->fetchAll(PDO::FETCH_ASSOC);

$total = 0;
$totalSold = 0;
foreach ($items as $it) {
  if ((int)$it['sold'] === 1) $totalSold += (float)($it['sold_price'] ?? 0);
  else $total += (float)$it['price'] * (int)$it['qty'];
}

?>
<div class="header">
  <div>
    <div class="brand"><?=h(cfg()['app_name'])?></div>
    <div class="small">Krabice: <b><?=h($box['title'] ?: $box['id'])?></b></div>
  </div>
  <a class="btn" href="<?=h(base_url('/index.php'))?>">Skenovat jinou</a>
</div>

<div class="card">
  <div class="row">
    <div class="col">
      <h1 class="h1">Obsah krabice</h1>
      <div class="small">Kód: <span class="pill"><?=h($box['id'])?></span></div>
    </div>
    <div class="col" style="text-align:right">
      <?php if ($show==='unsold'): ?>
        <div class="pill">Součet (neprodané): <b><?=number_format($total, 0, ',', ' ')?> Kč</b></div>
      <?php elseif ($show==='sold'): ?>
        <div class="pill">Součet (prodané): <b><?=number_format($totalSold, 0, ',', ' ')?> Kč</b></div>
      <?php else: ?>
        <div class="pill">Součet: <b><?=number_format($total, 0, ',', ' ')?> Kč</b> · Prodané: <b><?=number_format($totalSold, 0, ',', ' ')?> Kč</b></div>
      <?php endif; ?>
    </div>
  </div>

  <div class="footerlinks noPrint">
    <a class="btn <?= $show==='unsold'?'primary':'' ?>" href="<?=h(base_url('/box.php?box=' . urlencode($boxId) . '&show=unsold'))?>">Neprodané</a>
    <a class="btn <?= $show==='sold'?'primary':'' ?>" href="<?=h(base_url('/box.php?box=' . urlencode($boxId) . '&show=sold'))?>">Prodané</a>
    <a class="btn <?= $show==='all'?'primary':'' ?>" href="<?=h(base_url('/box.php?box=' . urlencode($boxId) . '&show=all'))?>">Vše</a>
    <a class="btn" href="<?=h(base_url('/print_box.php?box=' . urlencode($boxId) . '&show=' . urlencode($show)))?>">Tisk</a>
  </div>

  <div class="hr"></div>

  <?php if (!$items): ?>
    <div class="notice">Zatím tu nejsou žádné položky.</div>
  <?php else: ?>
    <?php foreach ($items as $it): ?>
      <div class="itemcard">
        <div class="thumb">
          <?php if (!empty($it['photo']) && file_exists(__DIR__ . '/' . $it['photo'])): ?>
            <img alt="" src="<?=h(base_url('/' . $it['photo']))?>">
          <?php else: ?>
            <span class="small">bez fotky</span>
          <?php endif; ?>
        </div>
        <div class="meta">
          <div class="title"><?=h($it['name'])?></div>
          <div class="line">
            <span class="pill">Množství: <b><?= (int)$it['qty'] ?></b></span>
            <?php if ((int)$it['sold']===1): ?>
              <span class="badge danger">PRODÁNO</span>
              <span class="pill">Cena prodej: <b><?=number_format((float)($it['sold_price']??0),0,',',' ')?> Kč</b></span>
              <?php if(!empty($it['sold_where'])): ?><span class="pill">Kde: <b><?=h($it['sold_where'])?></b></span><?php endif; ?>
              <?php if(!empty($it['sold_to'])): ?><span class="pill">Komu: <b><?=h($it['sold_to'])?></b></span><?php endif; ?>
            <?php else: ?>
              <span class="pill">Cena: <b><?=number_format((float)$it['price'],0,',',' ')?> Kč</b></span>
              <span class="pill">Mezisoučet: <b><?=number_format((float)$it['price']*(int)$it['qty'],0,',',' ')?> Kč</b></span>
            <?php endif; ?>
          </div>
          <div class="line" style="margin-top:6px">
            <?php if ((int)$it['adv_bazos']): ?><span class="badge ok">Bazoš</span><?php endif; ?>
            <?php if ((int)$it['adv_sbazar']): ?><span class="badge ok">Sbazar</span><?php endif; ?>
            <?php if ((int)$it['adv_aukro']): ?><span class="badge ok">Aukro</span><?php endif; ?>
            <?php if ((int)$it['adv_other']): ?><span class="badge ok">Jiné</span><?php endif; ?>
            <span class="small">Čárový kód: <?=h($it['barcode'])?></span>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>
</div>

<?php render_footer(); ?>
