async function startBarcodeScan(videoEl, onResult){
  const supports = ('BarcodeDetector' in window);
  if(!supports){
    alert('V tomto prohlížeči není dostupné BarcodeDetector API. Použijte prosím ruční zadání nebo externí skener.');
    return {stop:()=>{}};
  }
  const detector = new BarcodeDetector({formats:['ean_13','ean_8','code_128','code_39','upc_a','upc_e','itf']});
  const stream = await navigator.mediaDevices.getUserMedia({video:{facingMode:'environment'}});
  videoEl.srcObject = stream;
  await videoEl.play();

  let stopped=false;
  async function tick(){
    if(stopped) return;
    try{
      const barcodes = await detector.detect(videoEl);
      if(barcodes && barcodes.length){
        const code = (barcodes[0].rawValue||'').trim();
        if(code){
          onResult(code);
          stop();
          return;
        }
      }
    }catch(e){}
    requestAnimationFrame(tick);
  }
  requestAnimationFrame(tick);

  function stop(){
    stopped=true;
    try{ videoEl.pause(); }catch(e){}
    if(videoEl.srcObject){
      for(const t of videoEl.srcObject.getTracks()) t.stop();
    }
    videoEl.srcObject=null;
  }
  return {stop};
}
