<?php
require_once __DIR__ . '/../lib/layout.php';
require_once __DIR__ . '/../lib/auth.php';

$err = '';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $pw = $_POST['password'] ?? '';
  if (login($pw)) {
    header('Location: ' . base_url('/admin/dashboard.php'));
    exit;
  } else {
    $err = 'Špatné heslo.';
  }
}

render_header('Admin · Přihlášení');
?>
<div class="header">
  <div class="brand"><?=h(cfg()['app_name'])?> · Admin</div>
  <a class="btn" href="<?=h(base_url('/index.php'))?>">Veřejná část</a>
</div>

<div class="card">
  <h1 class="h1">Přihlášení</h1>
  <p class="small">Výchozí heslo je <b>admin</b> (změňte v <span class="pill">config.php</span>).</p>

  <?php if($err): ?><div class="notice" style="border-color:rgba(251,113,133,.35);color:#fff"><?=h($err)?></div><?php endif; ?>

  <form method="post">
    <label for="password">Heslo</label>
    <input class="input" id="password" name="password" type="password" autofocus>
    <div class="footerlinks">
      <button class="btn primary" type="submit">Přihlásit</button>
    </div>
  </form>
</div>
<?php render_footer(); ?>
