<?php
require_once __DIR__ . '/lib/layout.php';
require_once __DIR__ . '/lib/barcode.php';
$pdo = db();

$boxId = trim($_GET['box'] ?? '');
if (!$boxId) { header('Location: ' . base_url('/index.php')); exit; }

$st = $pdo->prepare('SELECT * FROM boxes WHERE id=?');
$st->execute([$boxId]);
$box = $st->fetch(PDO::FETCH_ASSOC);
if (!$box) { header('Location: ' . base_url('/index.php')); exit; }

$boxCode = strtoupper($boxId);
$qrUrl = absolute_url('/box.php?box=' . urlencode($boxId));

render_header('Tisk štítku', '<script src="'.h(base_url('/assets/qrcode.min.js')).'"></script>');
?>
<div class="header noPrint">
  <div>
    <div class="brand"><?=h(cfg()['app_name'])?></div>
    <div class="small">Tisk štítku krabice</div>
  </div>
  <div class="footerlinks">
    <a class="btn" href="<?=h(base_url('/box.php?box=' . urlencode($boxId)))?>">Zpět</a>
    <button class="btn primary" onclick="window.print()">Tisk</button>
  </div>
</div>

<div class="card label">
  <div class="labelRow">
    <div class="labelCol">
      <div class="h2" style="margin:0 0 8px 0"><?=h($box['title'] ?: 'Krabice')?></div>
      <div class="small">Kód krabice:</div>
      <div class="codeText"><?=h($boxCode)?></div>
      <div class="small" style="margin-top:10px">QR vede na:</div>
      <div class="small" style="word-break:break-all"><?=h($qrUrl)?></div>
    </div>

    <div class="labelCol" style="align-items:center">
      <div id="qrcode"></div>
    </div>
  </div>

  <div class="hr"></div>

  <div class="barcodeWrap">
    <?= code39_svg($boxCode, 70, 2) ?>
    <div class="barcodeText"><?=h($boxCode)?></div>
  </div>
</div>

<script>
  new QRCode(document.getElementById("qrcode"), {
    text: <?= json_encode($qrUrl) ?>,
    width: 180,
    height: 180,
    correctLevel: QRCode.CorrectLevel.M
  });
</script>

<style>
.label{max-width:720px;margin:0 auto}
.labelRow{display:flex;gap:14px;align-items:flex-start;justify-content:space-between}
.labelCol{flex:1}
.codeText{font-size:20px;font-weight:800;letter-spacing:1px}
.barcodeWrap{display:flex;flex-direction:column;align-items:center;gap:6px}
.barcodeText{font-size:18px;font-weight:800;letter-spacing:1px}
#qrcode img, #qrcode canvas{border:1px solid rgba(148,163,184,.25);border-radius:12px;padding:8px;background:#fff}

@media print{
  .noPrint{display:none !important}
  body{background:#fff}
  .container{padding:0}
  .card{border:none;box-shadow:none}
}
</style>

<?php render_footer(); ?>
