<?php
// Jednoduchý generátor Code39 do SVG (bez externích knihoven).
// Podporované znaky: 0-9, A-Z, - . space $ / + % (běžné pro ID krabice).
function code39_svg(string $text, int $height=60, int $module=2): string {
  $text = strtoupper($text);
  // start/stop *
  $encoded = '*' . $text . '*';

  $patterns = [
    '0'=>'nnnwwnwnn','1'=>'wnnwnnnnw','2'=>'nnwwnnnnw','3'=>'wnwwnnnnn','4'=>'nnnwwnnnw',
    '5'=>'wnnwwnnnn','6'=>'nnwwwnnnn','7'=>'nnnwnnwnw','8'=>'wnnwnnwnn','9'=>'nnwwnnwnn',
    'A'=>'wnnnnwnnw','B'=>'nnwnnwnnw','C'=>'wnwnnwnnn','D'=>'nnnnwwnnw','E'=>'wnnnwwnnn',
    'F'=>'nnwnwwnnn','G'=>'nnnnnwwnw','H'=>'wnnnnwwnn','I'=>'nnwnnwwnn','J'=>'nnnnwwwnn',
    'K'=>'wnnnnnnww','L'=>'nnwnnnnww','M'=>'wnwnnnnwn','N'=>'nnnnwnnww','O'=>'wnnnwnnwn',
    'P'=>'nnwnwnnwn','Q'=>'nnnnnnwww','R'=>'wnnnnnwwn','S'=>'nnwnnnwwn','T'=>'nnnnwnwwn',
    'U'=>'wwnnnnnnw','V'=>'nwwnnnnnw','W'=>'wwwnnnnnn','X'=>'nwnnwnnnw','Y'=>'wwnnwnnnn',
    'Z'=>'nwwnwnnnn','-'=>'nwnnnnwnw','.'=>'wwnnnnwnn',' '=>'nwwnnnwnn','$'=>'nwnwnwnnn',
    '/'=>'nwnwnnnwn','+'=>'nwnnnwnwn','%'=>'nnnwnwnwn','*'=>'nwnnwnwnn'
  ];

  $x = 0;
  $bars = [];

  for ($i=0; $i<strlen($encoded); $i++) {
    $ch = $encoded[$i];
    if (!isset($patterns[$ch])) continue;
    $pat = $patterns[$ch];
    // 9 prvků: bar/space střídavě, začíná barem
    $isBar = true;
    for ($j=0; $j<9; $j++) {
      $w = ($pat[$j] === 'w') ? (3*$module) : (1*$module);
      if ($isBar) {
        $bars[] = '<rect x="'.$x.'" y="0" width="'.$w.'" height="'.$height.'" />';
      }
      $x += $w;
      $isBar = !$isBar;
    }
    // mezera mezi znaky (narrow space)
    $x += 1*$module;
  }

  $totalWidth = max($x, 1);
  $svg = '<svg xmlns="http://www.w3.org/2000/svg" width="'.$totalWidth.'" height="'.$height.'" viewBox="0 0 '.$totalWidth.' '.$height.'" role="img" aria-label="barcode">'
       . '<rect x="0" y="0" width="'.$totalWidth.'" height="'.$height.'" fill="#fff"/>'
       . '<g fill="#000">'.implode('', $bars).'</g>'
       . '</svg>';
  return $svg;
}
