<?php
require_once __DIR__ . '/layout.php';

function ensure_session() : void {
  if (session_status() !== PHP_SESSION_ACTIVE) {
    // kompatibilní i se starším PHP: jednoduché nastavení cookie přes ini
    @ini_set('session.cookie_httponly', '1');
    @ini_set('session.cookie_samesite', 'Lax');
    @session_start();
  }
}

function is_admin() : bool {
  ensure_session();
  return !empty($_SESSION['is_admin']);
}

function set_admin(bool $v) : void {
  ensure_session();
  $_SESSION['is_admin'] = $v ? 1 : 0;
}

function logout_admin() : void {
  ensure_session();
  $_SESSION = [];
  if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
      $params["path"] ?? '/', $params["domain"] ?? '', $params["secure"] ?? false, $params["httponly"] ?? true
    );
  }
  @session_destroy();
}

function check_pin(string $pin) : bool {
  $cfg = cfg();
  $expected = (string)($cfg['admin_pin'] ?? '9725');
  return hash_equals($expected, trim($pin));
}

// Pokud by někde zůstalo volání, nebudeme přesměrovávat na jinou stránku.
function require_admin() : void {
  if (!is_admin()) {
    http_response_code(403);
    echo 'Forbidden';
    exit;
  }
}
