<?php
require_once __DIR__ . '/lib/layout.php';
$cfg = cfg();

$errors = [];
$warnings = [];

$phpOk = version_compare(PHP_VERSION, '8.0.0', '>=');
if (!$phpOk) $errors[] = 'PHP 8.0+ je doporučeno. Aktuálně: ' . PHP_VERSION;

if (!extension_loaded('pdo_sqlite')) $errors[] = 'Chybí rozšíření pdo_sqlite (SQLite).';
if (!extension_loaded('sqlite3')) $warnings[] = 'Rozšíření sqlite3 není načtené (většinou nevadí, používáme PDO).';

$paths = [
  'data' => __DIR__ . '/data',
  'uploads' => __DIR__ . '/uploads',
];
foreach ($paths as $name=>$path) {
  if (!is_dir($path)) {
    if (!@mkdir($path, 0775, true)) $errors[] = "Nelze vytvořit složku /$name (zkontroluj práva).";
  }
  if (is_dir($path) && !is_writable($path)) {
    $errors[] = "Složka /$name není zapisovatelná (chmod 775/777 podle hostingu).";
  }
}

render_header('Instalace / kontrola');
?>
<div class="card">
  <h1 class="h1">Kontrola instalace</h1>
  <p class="small">Tato stránka ověří, že aplikace poběží hned po rozbalení ZIPu.</p>

  <?php if($errors): ?>
    <div class="notice" style="border-color:rgba(251,113,133,.35);color:#fff">
      <b>Chyby:</b>
      <ul>
        <?php foreach($errors as $e): ?><li><?=h($e)?></li><?php endforeach; ?>
      </ul>
    </div>
  <?php else: ?>
    <div class="notice" style="border-color:rgba(134,239,172,.35);color:#fff">
      ✅ Vypadá to dobře – aplikace by měla fungovat.
    </div>
  <?php endif; ?>

  <?php if($warnings): ?>
    <div class="notice">
      <b>Upozornění:</b>
      <ul>
        <?php foreach($warnings as $w): ?><li><?=h($w)?></li><?php endforeach; ?>
      </ul>
    </div>
  <?php endif; ?>

  <div class="hr"></div>
  <div class="footerlinks">
    <a class="btn primary" href="<?=h(base_url('/index.php'))?>">Otevřít aplikaci</a>
    </div>

  <div class="hr"></div>
  <h2 class="h2">Tipy pro spuštění</h2>
  <ul class="small">
    <li>Lokálně nejrychleji: <code>php -S localhost:8000</code> ve složce projektu.</li>
    <li>Pokud se fotky/DB neukládají, nastav práva na <code>/data</code> a <code>/uploads</code>.</li>
  </ul>
</div>
<?php render_footer(); ?>
