<?php
require_once __DIR__ . '/lib/layout.php';
$pdo = db();

$boxId = trim($_GET['box'] ?? '');
$show = $_GET['show'] ?? 'unsold';

if (!$boxId) { header('Location: ' . base_url('/index.php')); exit; }

$boxStmt = $pdo->prepare('SELECT * FROM boxes WHERE id = ?');
$boxStmt->execute([$boxId]);
$box = $boxStmt->fetch(PDO::FETCH_ASSOC);
if (!$box) { header('Location: ' . base_url('/index.php')); exit; }

$where = "i.box_id = :box_id";
if ($show === 'unsold') $where .= " AND i.sold = 0";
if ($show === 'sold') $where .= " AND i.sold = 1";

$stmt = $pdo->prepare("
  SELECT i.*, p.barcode, p.name
  FROM box_items i
  JOIN products p ON p.id = i.product_id
  WHERE $where
  ORDER BY i.sold ASC, p.name COLLATE NOCASE ASC
");
$stmt->execute([':box_id' => $boxId]);
$items = $stmt->fetchAll(PDO::FETCH_ASSOC);

render_header('Tisk', '<style>.container{max-width:1000px}</style>');
?>
<div class="card">
  <div class="header noPrint">
    <div>
      <div class="brand"><?=h(cfg()['app_name'])?></div>
      <div class="small">Tisk · Krabice: <b><?=h($box['title'] ?: $box['id'])?></b></div>
    </div>
    <button class="btn primary" onclick="window.print()">Tisknout</button>
  </div>

  <h1 class="h1">Obsah krabice: <?=h($box['title'] ?: $box['id'])?></h1>
  <p class="small">Kód: <?=h($box['id'])?> · Režim: <?=h($show)?></p>

  <table class="table">
    <thead>
      <tr><th>Produkt</th><th>Množ.</th><th>Cena</th><th>Prodané</th><th>Prodejní cena</th><th>Čárový kód</th></tr>
    </thead>
    <tbody>
      <?php foreach($items as $it): ?>
        <tr class="tr">
          <td><?=h($it['name'])?></td>
          <td><?= (int)$it['qty'] ?></td>
          <td><?=number_format((float)$it['price'],0,',',' ')?> Kč</td>
          <td><?= (int)$it['sold'] ? 'ANO' : 'NE' ?></td>
          <td><?= (int)$it['sold'] ? (number_format((float)($it['sold_price']??0),0,',',' ') . ' Kč') : '' ?></td>
          <td><?=h($it['barcode'])?></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
<?php render_footer(); ?>
