<?php
require_once __DIR__ . '/lib/layout.php';
require_once __DIR__ . '/lib/auth.php';
$pdo = db();

ensure_session();

$msg=''; $err='';

// přesměrování po ručním zadání krabice
$box = $_GET['box'] ?? '';
if ($box) { header('Location: ' . base_url('/box.php?box=' . urlencode($box))); exit; }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $action = $_POST['action'] ?? '';

  if ($action === 'pin_login') {
    $pin = (string)($_POST['pin'] ?? '');
    if (check_pin($pin)) { set_admin(true); $msg='Admin režim aktivní.'; }
    else { $err='Špatný PIN.'; }
  } elseif ($action === 'pin_logout') {
    logout_admin();
    $msg='Admin režim vypnutý.';
  }

  // Admin akce na úvodní stránce (bez přechodu jinam)
  if (is_admin() && $action === 'create_box') {
    $title = trim($_POST['title'] ?? '');
    $id = bin2hex(random_bytes(16));
    $pdo->prepare('INSERT INTO boxes(id,title) VALUES(?,?)')->execute([$id, $title]);
    header('Location: ' . base_url('/box.php?box=' . urlencode($id)));
    exit;
  }
}

$boxes = [];
if (is_admin()) {
  $boxes = $pdo->query('SELECT * FROM boxes ORDER BY created_at DESC')->fetchAll(PDO::FETCH_ASSOC);
}

render_header('Sken QR');
?>
<div class="header">
  <div>
    <div class="brand"><?=h(cfg()['app_name'])?></div>
    <div class="small">Vstupní stránka</div>
  </div>

  <div class="footerlinks noPrint">
    <?php if(is_admin()): ?>
      <span class="badge ok">ADMIN</span>
      <form method="post" style="display:inline">
        <input type="hidden" name="action" value="pin_logout">
        <button class="btn danger" type="submit">Vypnout admin</button>
      </form>
    <?php else: ?>
      <button class="btn" type="button" onclick="document.getElementById('pinModal').style.display='flex'">Admin PIN</button>
    <?php endif; ?>
    <a class="btn" href="<?=h(base_url('/install.php'))?>">Kontrola</a>
  </div>
</div>

<?php if($msg): ?><div class="card"><div class="notice" style="border-color:rgba(134,239,172,.35);color:#fff"><?=h($msg)?></div></div><?php endif; ?>
<?php if($err): ?><div class="card"><div class="notice" style="border-color:rgba(251,113,133,.35);color:#fff"><?=h($err)?></div></div><?php endif; ?>

<div class="card">
  <h1 class="h1">Zobraz obsah krabice</h1>
  <p class="small">Otevři stránku přes QR kód (odkaz bude ve tvaru <span class="pill">.../box.php?box=XXXX</span>) nebo zadej kód ručně.</p>

  <form method="get" action="">
    <label for="box" class="small">Kód krabice</label>
    <input class="input" id="box" name="box" autocomplete="off" placeholder="např. 1a2b3c...">
    <div class="footerlinks" style="margin-top:10px">
      <button class="btn primary" type="submit">Otevřít krabici</button>
    </div>
  </form>
</div>

<?php if(is_admin()): ?>
  <div class="card noPrint">
    <h2 class="h2">Admin – přehled krabic</h2>

    <form method="post" class="row" style="margin-top:10px">
      <input type="hidden" name="action" value="create_box">
      <div class="col">
        <label for="title">Nová krabice – název (volitelné)</label>
        <input class="input" id="title" name="title" placeholder="např. Elektronika / Knihy / Mix…">
      </div>
      <div class="col" style="display:flex;align-items:flex-end">
        <button class="btn primary" type="submit" style="width:100%">Vytvořit krabici</button>
      </div>
    </form>

    <div class="hr"></div>

    <?php if(!$boxes): ?>
      <div class="notice">Zatím žádné krabice.</div>
    <?php else: ?>
      <?php foreach($boxes as $b): ?>
        <div class="line" style="justify-content:space-between;align-items:center;margin-top:10px">
          <div>
            <div class="title" style="margin:0"><?=h($b['title'] ?: $b['id'])?></div>
            <div class="small">ID: <?=h($b['id'])?></div>
          </div>
          <div class="footerlinks">
            <a class="btn" href="<?=h(base_url('/box.php?box=' . urlencode($b['id'])))?>">Otevřít</a>
            <a class="btn" href="<?=h(base_url('/print_box.php?box=' . urlencode($b['id'])))?>">Tisk obsahu</a>
          </div>
        </div>
      <?php endforeach; ?>
    <?php endif; ?>
  </div>
<?php endif; ?>

<div id="pinModal" class="modal noPrint" style="display:none">
  <div class="modalInner">
    <div class="h2" style="margin:0 0 10px 0">Admin PIN</div>
    <form method="post">
      <input type="hidden" name="action" value="pin_login">
      <label for="pin" class="small">Zadej PIN</label>
      <input class="input" id="pin" name="pin" inputmode="numeric" pattern="[0-9]*" autofocus placeholder="9725">
      <div class="footerlinks" style="margin-top:10px">
        <button class="btn primary" type="submit">Odemknout</button>
        <button class="btn" type="button" onclick="document.getElementById('pinModal').style.display='none'">Zavřít</button>
      </div>
    </form>
  </div>
</div>

<style>
.modal{position:fixed;inset:0;background:rgba(0,0,0,.6);display:flex;align-items:center;justify-content:center;padding:16px;z-index:9999}
.modalInner{max-width:420px;width:100%;background:#0b1220;border:1px solid rgba(148,163,184,.25);border-radius:18px;padding:16px;box-shadow:0 10px 30px rgba(0,0,0,.35)}
</style>
<script>
  const m = document.getElementById('pinModal');
  m.addEventListener('click', (e)=>{ if(e.target===m) m.style.display='none'; });
</script>

<?php render_footer(); ?>
