<?php
require_once __DIR__ . '/../lib/layout.php';
require_once __DIR__ . '/../lib/auth.php';
require_admin();
$pdo = db();

if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['action'] ?? '') === 'create_box') {
  $title = trim($_POST['title'] ?? '');
  $id = bin2hex(random_bytes(16));
  $pdo->prepare('INSERT INTO boxes(id,title) VALUES(?,?)')->execute([$id, $title]);
  header('Location: ' . base_url('/admin/box.php?box=' . urlencode($id)));
  exit;
}

$boxes = $pdo->query('SELECT * FROM boxes ORDER BY created_at DESC')->fetchAll(PDO::FETCH_ASSOC);

render_header('Admin · Přehled', '<script src="'.h(base_url('/assets/qrcode.min.js')).'"></script>');
?>
<div class="header">
  <div class="brand"><?=h(cfg()['app_name'])?> · Admin</div>
  <div class="footerlinks">
    <a class="btn" href="<?=h(base_url('/index.php'))?>">Veřejná část</a>
    <a class="btn" href="<?=h(base_url('/admin/export.php'))?>">Export</a>
    <a class="btn danger" href="<?=h(base_url('/admin/logout.php'))?>">Odhlásit</a>
  </div>
</div>

<div class="card">
  <h1 class="h1">Krabice</h1>
  <p class="small">Vytvoř krabici, vkládej produkty přes čárové kódy a tiskni QR štítek.</p>

  <form method="post" class="row">
    <input type="hidden" name="action" value="create_box">
    <div class="col">
      <label for="title">Název krabice (volitelné)</label>
      <input class="input" id="title" name="title" placeholder="např. Krabice A / regál 2" />
    </div>
    <div class="col" style="display:flex;align-items:flex-end">
      <button class="btn primary" type="submit" style="width:100%">+ Nová krabice</button>
    </div>
  </form>

  <div class="hr"></div>

  <?php if(!$boxes): ?>
    <div class="notice">Zatím nemáš žádné krabice.</div>
  <?php else: ?>
    <div class="grid">
      <?php foreach($boxes as $b): ?>
        <div class="card" style="padding:12px">
          <div style="display:flex;justify-content:space-between;gap:10px;align-items:flex-start">
            <div>
              <div class="h2"><?=h($b['title'] ?: $b['id'])?></div>
              <div class="small">Kód: <span class="pill"><?=h($b['id'])?></span></div>
            </div>
            <a class="btn primary" href="<?=h(base_url('/admin/box.php?box=' . urlencode($b['id'])))?>">Otevřít</a>
          </div>
          <div class="footerlinks" style="margin-top:10px">
            <a class="btn" href="<?=h(base_url('/box.php?box=' . urlencode($b['id'])))?>">Veřejný náhled</a>
            <a class="btn" href="<?=h(base_url('/admin/print_qr.php?box=' . urlencode($b['id'])))?>">Tisk QR</a>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>
</div>

<?php render_footer(); ?>
