/* Minimal QR generator (based on qrcode-generator by Kazuhiko Arase, MIT). */
(function(){
function QRMath(){this.EXP_TABLE=new Array(256);this.LOG_TABLE=new Array(256);for(var i=0;i<8;i++)this.EXP_TABLE[i]=1<<i;for(i=8;i<256;i++)this.EXP_TABLE[i]=this.EXP_TABLE[i-4]^this.EXP_TABLE[i-5]^this.EXP_TABLE[i-6]^this.EXP_TABLE[i-8];for(i=0;i<255;i++)this.LOG_TABLE[this.EXP_TABLE[i]]=i;}
QRMath.prototype.glog=function(n){if(n<1)throw new Error("glog");return this.LOG_TABLE[n];};
QRMath.prototype.gexp=function(n){while(n<0)n+=255;while(n>=256)n-=255;return this.EXP_TABLE[n];};
var QR_MATH=new QRMath();

function QRPolynomial(num,shift){if(num.length==undefined)throw new Error("QRPolynomial");var offset=0;while(offset<num.length && num[offset]==0)offset++;this.num=new Array(num.length-offset+shift);for(var i=0;i<num.length-offset;i++)this.num[i]=num[i+offset];}
QRPolynomial.prototype.get=function(i){return this.num[i];};
QRPolynomial.prototype.getLength=function(){return this.num.length;};
QRPolynomial.prototype.multiply=function(e){var num=new Array(this.getLength()+e.getLength()-1);for(var i=0;i<num.length;i++)num[i]=0;for(i=0;i<this.getLength();i++)for(var j=0;j<e.getLength();j++)num[i+j]^=QR_MATH.gexp(QR_MATH.glog(this.get(i))+QR_MATH.glog(e.get(j)));return new QRPolynomial(num,0);};
QRPolynomial.prototype.mod=function(e){if(this.getLength()-e.getLength()<0)return this;var ratio=QR_MATH.glog(this.get(0))-QR_MATH.glog(e.get(0));var num=this.num.slice();for(var i=0;i<e.getLength();i++)num[i]^=QR_MATH.gexp(QR_MATH.glog(e.get(i))+ratio);return new QRPolynomial(num,0).mod(e);};

var QRErrorCorrectLevel={L:1,M:0,Q:3,H:2};
var QRMaskPattern={PATTERN000:0,PATTERN001:1,PATTERN010:2,PATTERN011:3,PATTERN100:4,PATTERN101:5,PATTERN110:6,PATTERN111:7};

function QRBitBuffer(){this.buffer=[];this.length=0;}
QRBitBuffer.prototype.get=function(index){var bufIndex=Math.floor(index/8);return ((this.buffer[bufIndex]>>> (7-index%8))&1)==1;};
QRBitBuffer.prototype.put=function(num,length){for(var i=0;i<length;i++)this.putBit(((num>>> (length-i-1))&1)==1);};
QRBitBuffer.prototype.putBit=function(bit){var bufIndex=Math.floor(this.length/8);if(this.buffer.length<=bufIndex)this.buffer.push(0);if(bit)this.buffer[bufIndex]|=(0x80>>> (this.length%8));this.length++;};

function QR8bitByte(data){this.mode=1;this.data=data;}
QR8bitByte.prototype.getLength=function(){return unescape(encodeURIComponent(this.data)).length;};
QR8bitByte.prototype.write=function(buffer){var data=unescape(encodeURIComponent(this.data));for(var i=0;i<data.length;i++)buffer.put(data.charCodeAt(i),8);};

function QRRSBlock(totalCount,dataCount){this.totalCount=totalCount;this.dataCount=dataCount;}
QRRSBlock.getRSBlocks=function(typeNumber,errorCorrectLevel){
var rsBlockTable = QRRSBlock.RS_BLOCK_TABLE[(typeNumber-1)*4+errorCorrectLevel];
if(typeof rsBlockTable=="undefined") throw new Error("bad rsBlock");
var list=[];for(var i=0;i<rsBlockTable.length/3;i++){var count=rsBlockTable[i*3+0];var total=rsBlockTable[i*3+1];var data=rsBlockTable[i*3+2];for(var j=0;j<count;j++)list.push(new QRRSBlock(total,data));}
return list;
};
// Table truncated to types 1-10 for compactness (enough for URLs/IDs)
QRRSBlock.RS_BLOCK_TABLE=[
[1,26,19],[1,26,16],[1,26,13],[1,26,9],
[1,44,34],[1,44,28],[1,44,22],[1,44,16],
[1,70,55],[1,70,44],[2,35,17],[2,35,13],
[1,100,80],[2,50,32],[2,50,24],[4,25,9],
[1,134,108],[2,67,43],[2,33,15,2,34,16],[2,33,11,2,34,12],
[2,86,68],[4,43,27],[4,43,19],[4,43,15],
[2,98,78],[4,49,31],[2,32,14,4,33,15],[4,39,13,1,40,14],
[2,121,97],[2,60,38,2,61,39],[4,40,18,2,41,19],[4,40,14,2,41,15],
[2,146,116],[3,58,36,2,59,37],[4,36,16,4,37,17],[4,36,12,4,37,13],
[2,86,68,2,87,69],[4,69,43,1,70,44],[6,43,19,2,44,20],[6,43,15,2,44,16]
];

function QRUtil(){}
QRUtil.PATTERN_POSITION_TABLE=[[],[6,18],[6,22],[6,26],[6,30],[6,34],[6,22,38],[6,24,42],[6,26,46],[6,28,50],[6,30,54]];
QRUtil.G15=1<<10|1<<8|1<<5|1<<4|1<<2|1<<1|1;
QRUtil.G18=1<<12|1<<11|1<<10|1<<9|1<<8|1<<5|1<<2|1;
QRUtil.G15_MASK=1<<14|1<<12|1<<10|1<<4|1<<1;
QRUtil.getBCHTypeInfo=function(data){var d=data<<10;while(QRUtil.getBCHDigit(d)-QRUtil.getBCHDigit(QRUtil.G15)>=0)d^=(QRUtil.G15<< (QRUtil.getBCHDigit(d)-QRUtil.getBCHDigit(QRUtil.G15)));return ((data<<10)|d)^QRUtil.G15_MASK;};
QRUtil.getBCHTypeNumber=function(data){var d=data<<12;while(QRUtil.getBCHDigit(d)-QRUtil.getBCHDigit(QRUtil.G18)>=0)d^=(QRUtil.G18<< (QRUtil.getBCHDigit(d)-QRUtil.getBCHDigit(QRUtil.G18)));return (data<<12)|d;};
QRUtil.getBCHDigit=function(data){var digit=0;while(data!=0){digit++;data>>>=1;}return digit;};
QRUtil.getPatternPosition=function(typeNumber){return QRUtil.PATTERN_POSITION_TABLE[typeNumber-1];};
QRUtil.getMask=function(maskPattern,i,j){
switch(maskPattern){
case 0:return (i+j)%2==0;
case 1:return i%2==0;
case 2:return j%3==0;
case 3:return (i+j)%3==0;
case 4:return (Math.floor(i/2)+Math.floor(j/3))%2==0;
case 5:return (i*j)%2+(i*j)%3==0;
case 6:return ((i*j)%2+(i*j)%3)%2==0;
case 7:return ((i*j)%3+(i+j)%2)%2==0;
default:throw new Error("bad maskPattern");
}};
QRUtil.getErrorCorrectPolynomial=function(errorCorrectLength){
var a=new QRPolynomial([1],0);
for(var i=0;i<errorCorrectLength;i++)a=a.multiply(new QRPolynomial([1,QR_MATH.gexp(i)],0));
return a;
};
QRUtil.getLengthInBits=function(mode,type){
if(1<=type && type<10){switch(mode){case 1:return 8;default: return 8;}}
else{switch(mode){case 1:return 16;default:return 16;}}
};
QRUtil.getLostPoint=function(qr){
var moduleCount=qr.getModuleCount();
var lostPoint=0;
for(var row=0;row<moduleCount;row++){
for(var col=0;col<moduleCount;col++){
var sameCount=0;var dark=qr.isDark(row,col);
for(var r=-1;r<=1;r++){if(row+r<0||moduleCount<=row+r)continue;
for(var c=-1;c<=1;c++){if(col+c<0||moduleCount<=col+c)continue;
if(r==0&&c==0)continue;
if(dark==qr.isDark(row+r,col+c))sameCount++;}}
if(sameCount>5)lostPoint+=(3+sameCount-5);
}}
for(row=0;row<moduleCount-1;row++){
for(col=0;col<moduleCount-1;col++){
var count=0;
if(qr.isDark(row,col))count++;
if(qr.isDark(row+1,col))count++;
if(qr.isDark(row,col+1))count++;
if(qr.isDark(row+1,col+1))count++;
if(count==0||count==4)lostPoint+=3;
}}
for(row=0;row<moduleCount;row++){
for(col=0;col<moduleCount-6;col++){
if(qr.isDark(row,col)&&!qr.isDark(row,col+1)&&qr.isDark(row,col+2)&&qr.isDark(row,col+3)&&qr.isDark(row,col+4)&&!qr.isDark(row,col+5)&&qr.isDark(row,col+6))lostPoint+=40;
}}
for(col=0;col<moduleCount;col++){
for(row=0;row<moduleCount-6;row++){
if(qr.isDark(row,col)&&!qr.isDark(row+1,col)&&qr.isDark(row+2,col)&&qr.isDark(row+3,col)&&qr.isDark(row+4,col)&&!qr.isDark(row+5,col)&&qr.isDark(row+6,col))lostPoint+=40;
}}
var darkCount=0;
for(col=0;col<moduleCount;col++)for(row=0;row<moduleCount;row++)if(qr.isDark(row,col))darkCount++;
var ratio=Math.abs(100*darkCount/moduleCount/moduleCount-50)/5;
lostPoint+=ratio*10;
return lostPoint;
};

function QRCodeModel(typeNumber, errorCorrectLevel){
this.typeNumber=typeNumber;
this.errorCorrectLevel=errorCorrectLevel;
this.modules=null;
this.moduleCount=0;
this.dataCache=null;
this.dataList=[];
}
QRCodeModel.prototype.addData=function(data){this.dataList.push(new QR8bitByte(data));this.dataCache=null;};
QRCodeModel.prototype.isDark=function(row,col){if(this.modules[row][col]!=null)return this.modules[row][col]; else return false;};
QRCodeModel.prototype.getModuleCount=function(){return this.moduleCount;};
QRCodeModel.prototype.make=function(){this.makeImpl(false,this.getBestMaskPattern());};
QRCodeModel.prototype.makeImpl=function(test, maskPattern){
this.moduleCount=this.typeNumber*4+17;
this.modules=new Array(this.moduleCount);
for(var row=0;row<this.moduleCount;row++){this.modules[row]=new Array(this.moduleCount);for(var col=0;col<this.moduleCount;col++)this.modules[row][col]=null;}
this.setupPositionProbePattern(0,0);
this.setupPositionProbePattern(this.moduleCount-7,0);
this.setupPositionProbePattern(0,this.moduleCount-7);
this.setupPositionAdjustPattern();
this.setupTimingPattern();
this.setupTypeInfo(test,maskPattern);
if(this.typeNumber>=7)this.setupTypeNumber(test);
if(this.dataCache==null)this.dataCache=QRCodeModel.createData(this.typeNumber,this.errorCorrectLevel,this.dataList);
this.mapData(this.dataCache,maskPattern);
};
QRCodeModel.prototype.setupPositionProbePattern=function(row,col){
for(var r=-1;r<=7;r++){
if(row+r<=-1||this.moduleCount<=row+r)continue;
for(var c=-1;c<=7;c++){
if(col+c<=-1||this.moduleCount<=col+c)continue;
if((0<=r&&r<=6&&(c==0||c==6))||(0<=c&&c<=6&&(r==0||r==6))||(2<=r&&r<=4&&2<=c&&c<=4))this.modules[row+r][col+c]=true;
else this.modules[row+r][col+c]=false;
}}
};
QRCodeModel.prototype.getBestMaskPattern=function(){
var minLostPoint=0;var pattern=0;
for(var i=0;i<8;i++){
this.makeImpl(true,i);
var lostPoint=QRUtil.getLostPoint(this);
if(i==0||minLostPoint>lostPoint){minLostPoint=lostPoint;pattern=i;}
}
return pattern;
};
QRCodeModel.prototype.setupTimingPattern=function(){
for(var i=8;i<this.moduleCount-8;i++){
if(this.modules[i][6]!=null)continue;
this.modules[i][6]=(i%2==0);
if(this.modules[6][i]!=null)continue;
this.modules[6][i]=(i%2==0);
}
};
QRCodeModel.prototype.setupPositionAdjustPattern=function(){
var pos=QRUtil.getPatternPosition(this.typeNumber);
for(var i=0;i<pos.length;i++){
for(var j=0;j<pos.length;j++){
var row=pos[i], col=pos[j];
if(this.modules[row][col]!=null)continue;
for(var r=-2;r<=2;r++)for(var c=-2;c<=2;c++){
if(r==-2||r==2||c==-2||c==2|| (r==0&&c==0)) this.modules[row+r][col+c]=true;
else this.modules[row+r][col+c]=false;
}
}
}
};
QRCodeModel.prototype.setupTypeNumber=function(test){
var bits=QRUtil.getBCHTypeNumber(this.typeNumber);
for(var i=0;i<18;i++){
var mod=!test && ((bits>>i)&1)==1;
this.modules[Math.floor(i/3)][i%3+this.moduleCount-8-3]=mod;
}
for(i=0;i<18;i++){
mod=!test && ((bits>>i)&1)==1;
this.modules[i%3+this.moduleCount-8-3][Math.floor(i/3)]=mod;
}
};
QRCodeModel.prototype.setupTypeInfo=function(test,maskPattern){
var data=(QRErrorCorrectLevel[this.errorCorrectLevel]<<3)|maskPattern;
var bits=QRUtil.getBCHTypeInfo(data);
for(var i=0;i<15;i++){
var mod=!test && ((bits>>i)&1)==1;
if(i<6)this.modules[i][8]=mod;
else if(i<8)this.modules[i+1][8]=mod;
else this.modules[this.moduleCount-15+i][8]=mod;
}
for(i=0;i<15;i++){
mod=!test && ((bits>>i)&1)==1;
if(i<8)this.modules[8][this.moduleCount-i-1]=mod;
else if(i<9)this.modules[8][15-i-1+1]=mod;
else this.modules[8][15-i-1]=mod;
}
this.modules[this.moduleCount-8][8]=!test;
};
QRCodeModel.prototype.mapData=function(data,maskPattern){
var inc=-1;var row=this.moduleCount-1;var bitIndex=7;var byteIndex=0;
for(var col=this.moduleCount-1;col>0;col-=2){
if(col==6)col--;
while(true){
for(var c=0;c<2;c++){
if(this.modules[row][col-c]==null){
var dark=false;
if(byteIndex<data.length){dark=((data[byteIndex]>>>bitIndex)&1)==1;}
var mask=QRUtil.getMask(maskPattern,row,col-c);
if(mask)dark=!dark;
this.modules[row][col-c]=dark;
bitIndex--;
if(bitIndex==-1){byteIndex++;bitIndex=7;}
}}
row+=inc;
if(row<0||this.moduleCount<=row){row-=inc;inc=-inc;break;}
}
}
};
QRCodeModel.PAD0=0xEC;QRCodeModel.PAD1=0x11;
QRCodeModel.createData=function(typeNumber,errorCorrectLevel,dataList){
var rsBlocks=QRRSBlock.getRSBlocks(typeNumber, {M:0,L:1,Q:2,H:3}[errorCorrectLevel] ?? 0);
var buffer=new QRBitBuffer();
for(var i=0;i<dataList.length;i++){
var data=dataList[i];
buffer.put(4,4); // 8bit mode
buffer.put(data.getLength(), QRUtil.getLengthInBits(1,typeNumber));
data.write(buffer);
}
var totalDataCount=0;
for(i=0;i<rsBlocks.length;i++) totalDataCount += rsBlocks[i].dataCount;
if(buffer.length>totalDataCount*8) throw new Error("code length overflow");
if(buffer.length+4<=totalDataCount*8) buffer.put(0,4);
while(buffer.length%8!=0) buffer.putBit(false);
while(true){
if(buffer.length>=totalDataCount*8)break;
buffer.put(QRCodeModel.PAD0,8);
if(buffer.length>=totalDataCount*8)break;
buffer.put(QRCodeModel.PAD1,8);
}
return QRCodeModel.createBytes(buffer,rsBlocks);
};
QRCodeModel.createBytes=function(buffer,rsBlocks){
var offset=0;
var maxDcCount=0, maxEcCount=0;
var dcdata=new Array(rsBlocks.length);
var ecdata=new Array(rsBlocks.length);
for(var r=0;r<rsBlocks.length;r++){
var dcCount=rsBlocks[r].dataCount;
var ecCount=rsBlocks[r].totalCount-dcCount;
maxDcCount=Math.max(maxDcCount,dcCount);
maxEcCount=Math.max(maxEcCount,ecCount);
dcdata[r]=new Array(dcCount);
for(var i=0;i<dcdata[r].length;i++) dcdata[r][i]=0xff & buffer.buffer[i+offset];
offset += dcCount;
var rsPoly=QRUtil.getErrorCorrectPolynomial(ecCount);
var rawPoly=new QRPolynomial(dcdata[r], rsPoly.getLength()-1);
var modPoly=rawPoly.mod(rsPoly);
ecdata[r]=new Array(rsPoly.getLength()-1);
for(i=0;i<ecdata[r].length;i++){
var modIndex=i+modPoly.getLength()-ecdata[r].length;
ecdata[r][i]=(modIndex>=0)?modPoly.get(modIndex):0;
}
}
var totalCodeCount=0;
for(r=0;r<rsBlocks.length;r++) totalCodeCount += rsBlocks[r].totalCount;
var data=new Array(totalCodeCount);
var index=0;
for(i=0;i<maxDcCount;i++) for(r=0;r<rsBlocks.length;r++) if(i<dcdata[r].length) data[index++]=dcdata[r][i];
for(i=0;i<maxEcCount;i++) for(r=0;r<rsBlocks.length;r++) if(i<ecdata[r].length) data[index++]=ecdata[r][i];
return data;
};

window.QRBoxQR = {
  toCanvas: function(text, canvas, scale){
    scale = scale || 6;
    // pick a type number that fits (1-10)
    var type=1;
    for(type=1; type<=10; type++){
      try{
        var qr = new QRCodeModel(type,'M');
        qr.addData(text); qr.make();
        var c = canvas; var ctx = c.getContext('2d');
        var mc = qr.getModuleCount();
        c.width = c.height = mc*scale;
        ctx.clearRect(0,0,c.width,c.height);
        for(var r=0;r<mc;r++){
          for(var col=0;col<mc;col++){
            ctx.fillStyle = qr.isDark(r,col) ? '#000' : '#fff';
            ctx.fillRect(col*scale, r*scale, scale, scale);
          }
        }
        return;
      }catch(e){}
    }
    throw new Error("QR too long");
  }
};
})();
