<?php
// Jednoduchý bootstrap: ukládá fatální chyby do data/error.log a zobrazí přátelskou stránku.
set_error_handler(function($severity, $message, $file, $line){
  if (!(error_reporting() & $severity)) return false;
  throw new ErrorException($message, 0, $severity, $file, $line);
});

register_shutdown_function(function(){
  $err = error_get_last();
  if ($err && in_array($err['type'], [E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR])) {
    $dir = __DIR__ . '/../data';
    if (!is_dir($dir)) @mkdir($dir, 0775, true);
    $log = $dir . '/error.log';
    $line = date('c') . " | {$err['message']} | {$err['file']}:{$err['line']}
";
    @file_put_contents($log, $line, FILE_APPEND);
    if (!headers_sent()) {
      http_response_code(500);
      header('Content-Type: text/html; charset=utf-8');
    }
    $msg = htmlspecialchars($err['message'], ENT_QUOTES, 'UTF-8');
    echo '<!doctype html><meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">';
    echo '<title>Chyba aplikace</title>';
    echo '<div style="font-family:system-ui,Segoe UI,Roboto,Arial;padding:16px;max-width:720px;margin:0 auto">';
    echo '<h1>Chyba aplikace</h1>';
    echo '<p>Mrkni do <code>/data/error.log</code> nebo otevři <a href="install.php">install.php</a>.</p>';
    echo '<p style="background:#f6f6f6;padding:12px;border-radius:8px;white-space:pre-wrap">Detail: ' . $msg . '</p>';
    echo '</div>';
  }
});
