<?php
require_once __DIR__ . '/lib/bootstrap.php';
require_once __DIR__ . '/lib/layout.php';
require_once __DIR__ . '/lib/auth.php';
$pdo = db();

$boxId = trim($_GET['box'] ?? '');
if (!$boxId) { header('Location: ' . base_url('/index.php')); exit; }

$boxStmt = $pdo->prepare('SELECT * FROM boxes WHERE id = ?');
$boxStmt->execute([$boxId]);
$box = $boxStmt->fetch(PDO::FETCH_ASSOC);
if (!$box) { header('Location: ' . base_url('/index.php')); exit; }

ensure_session();

$msg=''; $err='';

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $action = $_POST['action'] ?? '';

  if ($action === 'pin_login') {
    $pin = (string)($_POST['pin'] ?? '');
    if (check_pin($pin)) { set_admin(true); $msg='Admin režim aktivní.'; }
    else { $err='Špatný PIN.'; }
  } elseif ($action === 'pin_logout') {
    logout_admin();
    $msg='Admin režim vypnutý.';
  }

  if (is_admin()) {
    if ($action === 'add_barcode') {
      $barcode = trim($_POST['barcode'] ?? '');
      $qty = (int)($_POST['qty'] ?? 1); if ($qty < 1) $qty = 1;
      $price = (float)str_replace(',', '.', ($_POST['price'] ?? '0'));
      $adv_bazos = !empty($_POST['adv_bazos']) ? 1 : 0;
      $adv_sbazar = !empty($_POST['adv_sbazar']) ? 1 : 0;
      $adv_aukro = !empty($_POST['adv_aukro']) ? 1 : 0;
      $adv_other = !empty($_POST['adv_other']) ? 1 : 0;

      if (!$barcode) { $err='Zadej čárový kód.'; }
      else {
        $p = $pdo->prepare('SELECT * FROM products WHERE barcode = ?');
        $p->execute([$barcode]);
        $prod = $p->fetch(PDO::FETCH_ASSOC);
        if (!$prod) {
          $pdo->prepare('INSERT INTO products(barcode,name,default_price,buy_price,notes) VALUES(?,?,?,?,?)')
              ->execute([$barcode, 'Nový produkt ' . $barcode, 0, 0, '']);
          $prodId = (int)$pdo->lastInsertId();
          $prod = $pdo->query('SELECT * FROM products WHERE id=' . (int)$prodId)->fetch(PDO::FETCH_ASSOC);
        }

        $it = $pdo->prepare('SELECT * FROM box_items WHERE box_id = ? AND product_id = ? AND sold = 0');
        $it->execute([$boxId, $prod['id']]);
        $item = $it->fetch(PDO::FETCH_ASSOC);
        if ($item) {
          $newQty = (int)$item['qty'] + $qty;
          $newPrice = $price > 0 ? $price : (float)$item['price'];
          $pdo->prepare('UPDATE box_items SET qty=?, price=?, adv_bazos=?, adv_sbazar=?, adv_aukro=?, adv_other=? WHERE id=?')
              ->execute([$newQty, $newPrice, $adv_bazos, $adv_sbazar, $adv_aukro, $adv_other, $item['id']]);
        } else {
          $usePrice = $price > 0 ? $price : (float)$prod['default_price'];
          $pdo->prepare('INSERT INTO box_items(box_id, product_id, qty, price, adv_bazos, adv_sbazar, adv_aukro, adv_other) VALUES(?,?,?,?,?,?,?,?)')
              ->execute([$boxId, $prod['id'], $qty, $usePrice, $adv_bazos, $adv_sbazar, $adv_aukro, $adv_other]);
        }
        $msg = 'Přidáno: ' . ($prod['name'] ?? $barcode);
      }
    } elseif ($action === 'update_item') {
      $id = (int)($_POST['item_id'] ?? 0);
      $qty = (int)($_POST['qty'] ?? 1); if ($qty < 1) $qty = 1;
      $price = (float)str_replace(',', '.', ($_POST['price'] ?? '0'));
      $adv_bazos = !empty($_POST['adv_bazos']) ? 1 : 0;
      $adv_sbazar = !empty($_POST['adv_sbazar']) ? 1 : 0;
      $adv_aukro = !empty($_POST['adv_aukro']) ? 1 : 0;
      $adv_other = !empty($_POST['adv_other']) ? 1 : 0;
      $pdo->prepare('UPDATE box_items SET qty=?, price=?, adv_bazos=?, adv_sbazar=?, adv_aukro=?, adv_other=? WHERE id=? AND box_id=?')
          ->execute([$qty,$price,$adv_bazos,$adv_sbazar,$adv_aukro,$adv_other,$id,$boxId]);
      $msg='Uloženo.';
    } elseif ($action === 'mark_sold') {
      $id = (int)($_POST['item_id'] ?? 0);
      $sold_price = (float)str_replace(',', '.', ($_POST['sold_price'] ?? '0'));
      $sold_where = trim($_POST['sold_where'] ?? '');
      $sold_to = trim($_POST['sold_to'] ?? '');
      $sold_note = trim($_POST['sold_note'] ?? '');
      $pdo->prepare('UPDATE box_items SET sold=1, sold_price=?, sold_where=?, sold_to=?, sold_note=?, sold_at=CURRENT_TIMESTAMP WHERE id=? AND box_id=?')
          ->execute([$sold_price,$sold_where,$sold_to,$sold_note,$id,$boxId]);
      $msg='Označeno jako prodáno.';
    } elseif ($action === 'mark_unsold') {
      $id = (int)($_POST['item_id'] ?? 0);
      $pdo->prepare('UPDATE box_items SET sold=0, sold_price=NULL, sold_where=NULL, sold_to=NULL, sold_note=NULL, sold_at=NULL WHERE id=? AND box_id=?')
          ->execute([$id,$boxId]);
      $msg='Vráceno do neprodaných.';
    } elseif ($action === 'update_sold') {
      $id = (int)($_POST['item_id'] ?? 0);
      $sold_price = (float)str_replace(',', '.', ($_POST['sold_price'] ?? '0'));
      $sold_where = trim($_POST['sold_where'] ?? '');
      $sold_to = trim($_POST['sold_to'] ?? '');
      $sold_note = trim($_POST['sold_note'] ?? '');
      $pdo->prepare('UPDATE box_items SET sold_price=?, sold_where=?, sold_to=?, sold_note=? WHERE id=? AND box_id=? AND sold=1')
          ->execute([$sold_price,$sold_where,$sold_to,$sold_note,$id,$boxId]);
      $msg='Údaje o prodeji uloženy.';
    } elseif ($action === 'upload_attachment') {
      $id = (int)($_POST['item_id'] ?? 0);
      if ($id && !empty($_FILES['files']['name']) && is_array($_FILES['files']['name'])) {
        for ($i=0; $i<count($_FILES['files']['name']); $i++) {
          if (empty($_FILES['files']['name'][$i])) continue;
          if (!is_uploaded_file($_FILES['files']['tmp_name'][$i])) continue;
          $ext = strtolower(pathinfo($_FILES['files']['name'][$i], PATHINFO_EXTENSION));
          if (!in_array($ext, ['jpg','jpeg','png','webp'])) $ext='jpg';
          $fn = 'uploads/sold_' . date('Ymd_His') . '_' . bin2hex(random_bytes(4)) . '.' . $ext;
          $dest = __DIR__ . '/' . $fn;
          if (move_uploaded_file($_FILES['files']['tmp_name'][$i], $dest)) {
            $pdo->prepare('INSERT INTO item_attachments(item_id, path) VALUES(?,?)')->execute([$id, $fn]);
          }
        }
        $msg='Přílohy nahrány.';
      }
    } elseif ($action === 'delete_attachment') {
      $attId = (int)($_POST['att_id'] ?? 0);
      $itemId = (int)($_POST['item_id'] ?? 0);
      if ($attId && $itemId) {
        $st = $pdo->prepare('SELECT path FROM item_attachments WHERE id=? AND item_id=?');
        $st->execute([$attId, $itemId]);
        $path = (string)$st->fetchColumn();
        if ($path && file_exists(__DIR__ . '/' . $path)) @unlink(__DIR__ . '/' . $path);
        $pdo->prepare('DELETE FROM item_attachments WHERE id=? AND item_id=?')->execute([$attId, $itemId]);
        $msg='Příloha smazána.';
      }
    }
  }
}

$show = $_GET['show'] ?? 'unsold';
$q = trim($_GET['q'] ?? '');

$whereParts = ["i.box_id = :box_id"];
$params = [':box_id' => $boxId];

if ($show === 'unsold') $whereParts[] = "i.sold = 0";
if ($show === 'sold') $whereParts[] = "i.sold = 1";

if ($q !== '') {
  $whereParts[] = "(p.name LIKE :like OR p.barcode LIKE :like OR COALESCE(p.notes,'') LIKE :like)";
  $params[':like'] = '%' . $q . '%';
}

$where = implode(' AND ', $whereParts);

$stmt = $pdo->prepare("
  SELECT i.*, p.barcode, p.name, p.photo, p.buy_price
  FROM box_items i
  JOIN products p ON p.id = i.product_id
  WHERE $where
  ORDER BY i.sold ASC, p.name COLLATE NOCASE ASC
");
$stmt->execute($params);
$items = $stmt->fetchAll(PDO::FETCH_ASSOC);

$unsoldCount = 0; $soldCount = 0; $soldTotal = 0;
foreach ($items as $it) {
  if ((int)$it['sold'] === 1) { $soldCount++; $soldTotal += (float)($it['sold_price'] ?? 0); }
  else $unsoldCount++;
}

render_header('Krabice', '<script src="'.h(base_url('/assets/scan.js')).'"></script>');
?>
<div class="header">
  <div>
    <div class="brand"><?=h(cfg()['app_name'])?></div>
    <div class="small">Krabice: <b><?=h($box['title'] ?: $box['id'])?></b></div>
    <div class="small">Neprodané: <b><?= (int)$unsoldCount ?></b> · Prodané: <b><?= (int)$soldCount ?></b> · Celkem prodej: <b><?=number_format((float)$soldTotal,0,',',' ')?> Kč</b></div>
  </div>
  <div class="footerlinks noPrint">
    <?php if(is_admin()): ?>
      <span class="badge ok">ADMIN</span>
      <form method="post" style="display:inline">
        <input type="hidden" name="action" value="pin_logout">
        <button class="btn danger" type="submit">Vypnout admin</button>
      </form>
    <?php else: ?>
      <button class="btn" onclick="document.getElementById('pinModal').style.display='flex'">Admin PIN</button>
    <?php endif; ?>
    <a class="btn" href="<?=h(base_url('/print_box.php?box=' . urlencode($boxId)))?>">Tisk</a>
  </div>
</div>

<?php if($msg): ?><div class="card"><div class="notice" style="border-color:rgba(134,239,172,.35);color:#fff"><?=h($msg)?></div></div><?php endif; ?>
<?php if($err): ?><div class="card"><div class="notice" style="border-color:rgba(251,113,133,.35);color:#fff"><?=h($err)?></div></div><?php endif; ?>

<div class="card noPrint">
  <form method="get">
    <input type="hidden" name="box" value="<?=h($boxId)?>">
    <label for="q" class="small">Hledat v krabici</label>
    <input class="input" id="q" name="q" value="<?=h($q)?>" placeholder="název / EAN / poznámka...">
    <div class="footerlinks" style="margin-top:8px">
      <button class="btn" type="submit">Hledat</button>
      <?php if($q!==""): ?><a class="btn" href="<?=h(base_url('/box.php?box=' . urlencode($boxId)))?>">Zrušit</a><?php endif; ?>
      <a class="btn <?= $show==='unsold'?'primary':'' ?>" href="<?=h(base_url('/box.php?box=' . urlencode($boxId) . '&show=unsold&q=' . urlencode($q)))?>">Neprodané</a>
      <a class="btn <?= $show==='sold'?'primary':'' ?>" href="<?=h(base_url('/box.php?box=' . urlencode($boxId) . '&show=sold&q=' . urlencode($q)))?>">Prodané</a>
      <a class="btn <?= $show==='all'?'primary':'' ?>" href="<?=h(base_url('/box.php?box=' . urlencode($boxId) . '&show=all&q=' . urlencode($q)))?>">Vše</a>
    </div>
  </form>
</div>

<?php if(is_admin()): ?>
  <div class="card noPrint">
    <h2 class="h2">Admin – přidat produkt do krabice</h2>
    <form method="post" id="addForm">
      <input type="hidden" name="action" value="add_barcode">
      <label for="barcode">Čárový kód</label>
      <input class="input" id="barcode" name="barcode" placeholder="EAN / CODE128..." inputmode="numeric" autocomplete="off">
      <div class="row">
        <div class="col">
          <label for="qty">Množství</label>
          <input class="input" id="qty" name="qty" type="number" min="1" value="1">
        </div>
        <div class="col">
          <label for="price">Cena (Kč) — volitelně</label>
          <input class="input" id="price" name="price" type="number" step="0.01" min="0" placeholder="pokud prázdné, použije se výchozí">
        </div>
      </div>
      <label>Inzerce</label>
      <div class="row">
        <div class="col"><label class="pill"><input type="checkbox" name="adv_bazos" value="1"> Bazoš</label></div>
        <div class="col"><label class="pill"><input type="checkbox" name="adv_sbazar" value="1"> Sbazar</label></div>
        <div class="col"><label class="pill"><input type="checkbox" name="adv_aukro" value="1"> Aukro</label></div>
        <div class="col"><label class="pill"><input type="checkbox" name="adv_other" value="1"> Jiné</label></div>
      </div>
      <div class="footerlinks">
        <button class="btn primary" type="submit">Přidat</button>
        <button class="btn" type="button" id="startScanBtn">Sken kamerou</button>
      </div>
    </form>

    <div class="videoWrap" id="videoWrap" style="display:none;margin-top:12px">
      <video id="video" playsinline></video>
      <div class="scanBox"></div>
      <div class="scanHint">Namíř kameru na čárový kód…</div>
    </div>

    <script>
      const videoWrap = document.getElementById('videoWrap');
      const videoEl = document.getElementById('video');
      const startBtn = document.getElementById('startScanBtn');
      const barcodeInput = document.getElementById('barcode');

      startBtn.addEventListener('click', async () => {
        try{
          videoWrap.style.display = 'block';
          await startBarcodeScan(videoEl, (code) => {
            barcodeInput.value = code;
            videoWrap.style.display = 'none';
            document.getElementById('addForm').requestSubmit();
          });
        }catch(e){
          alert('Nepodařilo se spustit skenování: ' + (e?.message || e));
          videoWrap.style.display = 'none';
        }
      });
    </script>
  </div>
<?php endif; ?>

<div class="card">
  <h2 class="h2">Položky</h2>

  <?php if(!$items): ?>
    <div class="notice">Krabice je zatím prázdná.</div>
  <?php else: ?>
    <?php foreach($items as $it): ?>
      <div class="itemcard">
        <div class="thumb">
          <?php if (!empty($it['photo']) && file_exists(__DIR__ . '/' . $it['photo'])): ?>
            <img alt="" src="<?=h(base_url('/' . $it['photo']))?>">
          <?php else: ?><span class="small">bez fotky</span><?php endif; ?>
        </div>
        <div class="meta">
          <div class="title"><?=h($it['name'])?> <?php if((int)$it['sold']===1): ?><span class="badge danger">PRODÁNO</span><?php endif; ?></div>
          <div class="line">
            <span class="pill">Množství: <b><?= (int)$it['qty'] ?></b></span>
            <?php if((int)$it['sold']===1): ?>
              <span class="pill">Prodej: <b><?=number_format((float)($it['sold_price']??0),0,',',' ')?> Kč</b></span>
              <?php
                $profit = null;
                if (!empty($it['buy_price']) && (float)$it['buy_price']>0) $profit = (float)($it['sold_price']??0) - ((float)$it['buy_price'] * (int)$it['qty']);
              ?>
              <?php if($profit !== null): ?><span class="pill">Zisk: <b><?=number_format((float)$profit,0,',',' ')?> Kč</b></span><?php endif; ?>
              <?php if(!empty($it['sold_where'])): ?><span class="pill">Kde: <b><?=h($it['sold_where'])?></b></span><?php endif; ?>
              <?php if(!empty($it['sold_to'])): ?><span class="pill">Komu: <b><?=h($it['sold_to'])?></b></span><?php endif; ?>
            <?php else: ?>
              <span class="pill">Cena: <b><?=number_format((float)$it['price'],0,',',' ')?> Kč</b></span>
            <?php endif; ?>
            <span class="small">EAN: <?=h($it['barcode'])?></span>
          </div>

          <?php if(is_admin()): ?>
            <details style="margin-top:10px" class="noPrint">
              <summary class="small">Upravit / prodejní karta</summary>

              <?php if((int)$it['sold']===0): ?>
                <form method="post" style="margin-top:10px">
                  <input type="hidden" name="action" value="update_item">
                  <input type="hidden" name="item_id" value="<?= (int)$it['id'] ?>">
                  <label>Množství</label>
                  <input class="input" type="number" min="1" name="qty" value="<?= (int)$it['qty'] ?>">
                  <label>Cena (Kč)</label>
                  <input class="input" type="number" step="0.01" min="0" name="price" value="<?=h($it['price'])?>">
                  <label>Inzerce</label>
                  <div class="row">
                    <div class="col"><label class="pill"><input type="checkbox" name="adv_bazos" value="1" <?= (int)$it['adv_bazos']?'checked':'' ?>> Bazoš</label></div>
                    <div class="col"><label class="pill"><input type="checkbox" name="adv_sbazar" value="1" <?= (int)$it['adv_sbazar']?'checked':'' ?>> Sbazar</label></div>
                    <div class="col"><label class="pill"><input type="checkbox" name="adv_aukro" value="1" <?= (int)$it['adv_aukro']?'checked':'' ?>> Aukro</label></div>
                    <div class="col"><label class="pill"><input type="checkbox" name="adv_other" value="1" <?= (int)$it['adv_other']?'checked':'' ?>> Jiné</label></div>
                  </div>
                  <div class="footerlinks">
                    <button class="btn primary" type="submit">Uložit</button>
                  </div>
                </form>

                <form method="post" style="margin-top:10px">
                  <input type="hidden" name="action" value="mark_sold">
                  <input type="hidden" name="item_id" value="<?= (int)$it['id'] ?>">
                  <label>Prodejní cena (Kč)</label>
                  <input class="input" type="number" step="0.01" min="0" name="sold_price" placeholder="např. 499">
                  <label>Kde prodáno (platforma)</label>
                  <input class="input" name="sold_where" placeholder="např. Bazoš / Aukro / osobně">
                  <label>Komu (kupující)</label>
                  <input class="input" name="sold_to" placeholder="např. Jan N.">
                  <label>Poznámka</label>
                  <textarea class="input" name="sold_note" rows="2" placeholder="např. poslání, rezervace, ..."></textarea>
                  <div class="footerlinks">
                    <button class="btn ok" type="submit">Označit prodáno</button>
                  </div>
                </form>
              <?php else: ?>
                <form method="post" style="margin-top:10px">
                  <input type="hidden" name="action" value="update_sold">
                  <input type="hidden" name="item_id" value="<?= (int)$it['id'] ?>">
                  <label>Prodejní cena (Kč)</label>
                  <input class="input" type="number" step="0.01" min="0" name="sold_price" value="<?=h($it['sold_price'] ?? 0)?>">
                  <label>Kde prodáno (platforma)</label>
                  <input class="input" name="sold_where" value="<?=h($it['sold_where'] ?? '')?>">
                  <label>Komu (kupující)</label>
                  <input class="input" name="sold_to" value="<?=h($it['sold_to'] ?? '')?>">
                  <label>Poznámka</label>
                  <textarea class="input" name="sold_note" rows="2"><?=h($it['sold_note'] ?? '')?></textarea>
                  <div class="footerlinks">
                    <button class="btn primary" type="submit">Uložit</button>
                  </div>
                </form>

                <?php $attsStmt = $pdo->prepare('SELECT * FROM item_attachments WHERE item_id=? ORDER BY id DESC'); $attsStmt->execute([(int)$it['id']]); $atts = $attsStmt->fetchAll(PDO::FETCH_ASSOC); ?>
                <?php if(!empty($atts)): ?>
                  <div class="line" style="margin-top:10px;gap:8px;flex-wrap:wrap">
                    <?php foreach($atts as $a): ?>
                      <div style="display:flex;flex-direction:column;gap:6px;align-items:center">
                        <div class="thumb" style="width:56px;height:56px"><img alt="" src="<?=h(base_url('/' . $a['path']))?>"></div>
                        <form method="post" onsubmit="return confirm('Smazat přílohu?')">
                          <input type="hidden" name="action" value="delete_attachment">
                          <input type="hidden" name="att_id" value="<?= (int)$a['id'] ?>">
                          <input type="hidden" name="item_id" value="<?= (int)$it['id'] ?>">
                          <button class="btn danger" type="submit">Smazat</button>
                        </form>
                      </div>
                    <?php endforeach; ?>
                  </div>
                <?php endif; ?>

                <form method="post" enctype="multipart/form-data" style="margin-top:10px">
                  <input type="hidden" name="action" value="upload_attachment">
                  <input type="hidden" name="item_id" value="<?= (int)$it['id'] ?>">
                  <label>Přílohy (chat / doklad)</label>
                  <input class="input" type="file" name="files[]" accept="image/*" multiple>
                  <div class="footerlinks">
                    <button class="btn" type="submit">Nahrát přílohy</button>
                  </div>
                </form>

                <form method="post" style="margin-top:10px">
                  <input type="hidden" name="action" value="mark_unsold">
                  <input type="hidden" name="item_id" value="<?= (int)$it['id'] ?>">
                  <div class="footerlinks">
                    <button class="btn" type="submit">Vrátit do neprodaných</button>
                  </div>
                </form>
              <?php endif; ?>
            </details>
          <?php endif; ?>
        </div>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>
</div>

<div id="pinModal" class="modal noPrint" style="display:none">
  <div class="modalInner">
    <div class="h2" style="margin:0 0 10px 0">Admin PIN</div>
    <form method="post">
      <input type="hidden" name="action" value="pin_login">
      <label for="pin" class="small">Zadej PIN</label>
      <input class="input" id="pin" name="pin" inputmode="numeric" pattern="[0-9]*" autofocus placeholder="9725">
      <div class="footerlinks" style="margin-top:10px">
        <button class="btn primary" type="submit">Odemknout</button>
        <button class="btn" type="button" onclick="document.getElementById('pinModal').style.display='none'">Zavřít</button>
      </div>
    </form>
  </div>
</div>

<style>
.modal{position:fixed;inset:0;background:rgba(0,0,0,.6);display:flex;align-items:center;justify-content:center;padding:16px;z-index:9999}
.modalInner{max-width:420px;width:100%;background:#0b1220;border:1px solid rgba(148,163,184,.25);border-radius:18px;padding:16px;box-shadow:0 10px 30px rgba(0,0,0,.35)}
</style>
<script>
  const m = document.getElementById('pinModal');
  m.addEventListener('click', (e)=>{ if(e.target===m) m.style.display='none'; });
</script>

<?php render_footer(); ?>
