<?php
require_once __DIR__ . "/../src/init.php";
ensure_schema();

require_once __DIR__ . "/../src/auth.php";
require_once __DIR__ . "/../src/helpers.php";
require_login();

$cfg = require __DIR__ . "/../src/config.php";
$u = current_user();

$roleFilterSql = "";
$roleParams = [];
if ($u["role"] === "montér") {
  $roleFilterSql = " AND o.assigned_user_id = ?";
  $roleParams[] = (int)$u["id"];
}


$q = trim($_GET["q"] ?? "");
$status = trim($_GET["status"] ?? "");

$sql = "
  SELECT o.*, c.name AS client_name, u.name AS assigned_name
  FROM orders o
  JOIN clients c ON c.id=o.client_id
  LEFT JOIN users u ON u.id=o.assigned_user_id
  WHERE 1=1" . $roleFilterSql . "
";
$params = [];

if ($status !== "") { $sql .= " AND o.status = ?"; $params[] = $status; }
if ($q !== "") {
  $sql .= " AND (c.name LIKE ? OR o.title LIKE ? OR o.address LIKE ? OR o.flooring_type LIKE ? OR o.note LIKE ?)";
  $like = "%$q%";
  array_push($params, $like,$like,$like,$like,$like);
}

$sql .= " ORDER BY COALESCE(o.end_date, '2999-12-31') ASC, o.id DESC LIMIT 300";

$stmt = db()->prepare($sql);
$stmt->execute(array_merge($roleParams, $params));
$orders = $stmt->fetchAll();
?>
<!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Zakázky – Podlahářství</title>
  <link rel="stylesheet" href="assets/style.css" />
</head>
<body>
<header class="topbar">
  <div class="brand">
    <div class="logo">🧱</div>
    <div>
      <div class="brand-title"><?=h($cfg["app"]["company_name"])?> – Zakázky</div>
      <div class="brand-sub">Přihlášen: <?=h($u["name"])?> (<?=h($u["role"])?>)</div>
    </div>
  </div>
  <nav class="nav">
    <a href="dashboard.php">Dashboard</a>
    <a class="active" href="orders.php">Zakázky</a>
    <a href="calendar.php">Kalendář</a>
    <a href="clients.php">Klienti</a>
    <a href="pricelist.php">Ceník</a>
      <a href="logout.php">Odhlásit</a>
  </nav>
</header>

<main class="container">
  <section class="panel">
    <div class="panel-head">
      <h2>Seznam zakázek</h2>
      <div class="right">
        <a class="btn btn-primary" href="order_edit.php">+ Nová</a>
      </div>
    </div>
    <div class="panel-body">
      <form method="get" class="grid" style="margin-bottom:12px">
        <label class="field span-2">
          <span class="muted">Hledat</span>
          <input class="input" name="q" value="<?=h($q)?>" placeholder="klient, adresa, typ, poznámka…" />
        </label>
        <label class="field">
          <span class="muted">Status</span>
          <select class="input" name="status">
            <option value="">Všechny</option>
            <?php foreach (["Čeká","V běhu","Hotovo","Zrušeno"] as $st): ?>
              <option <?= $status===$st ? "selected":"" ?>><?=h($st)?></option>
            <?php endforeach; ?>
          </select>
        </label>
        <div class="field">
          <span class="muted">&nbsp;</span>
          <button class="btn btn-primary" type="submit">Filtrovat</button>
        </div>
      </form>

      <div class="table-wrap">
        <table class="table">
          <thead>
            <tr>
              <th>ID</th><th>Klient</th><th>Název</th><th>Typ</th><th>m²</th><th>Termín</th><th>Status</th><th>Montér</th><th>Akce</th>
            </tr>
          </thead>
          <tbody>
          <?php foreach ($orders as $o): ?>
            <?php
              $dot = match($o["status"]) {
                "Čeká" => "wait",
                "V běhu" => "run",
                "Hotovo" => "done",
                "Zrušeno" => "cancel",
                default => "run"
              };
            ?>
            <tr>
              <td class="muted">#<?= (int)$o["id"] ?></td>
              <td><strong><?=h($o["client_name"])?></strong><div class="muted"><?=h($o["address"])?></div></td>
              <td><?=h($o["title"])?></td>
              <td><?=h($o["flooring_type"])?></td>
              <td><?=h((string)$o["area_m2"])?></td>
              <td><?=h((string)($o["start_date"] ?? "—"))?> → <?=h((string)($o["end_date"] ?? "—"))?></td>
              <td><span class="badge"><span class="dot <?=$dot?>"></span><?=h($o["status"])?></span></td>
              <td><?=h($o["assigned_name"] ?? "—")?></td>
              <td>
                <a class="btn" href="order_view.php?id=<?=(int)$o["id"]?>">Detail</a>
                <a class="btn" href="order_edit.php?id=<?=(int)$o["id"]?>">Upravit</a>
                <a class="btn" href="print.php?id=<?=(int)$o["id"]?>&doc=nabidka" target="_blank">Tisk</a>
              </td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>

    </div>
  </section>
</main>
</body>
</html>
