<?php
require_once __DIR__ . "/../src/init.php";
ensure_schema();

require_once __DIR__ . "/../src/auth.php";
require_once __DIR__ . "/../src/helpers.php";

start_session();
$error = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
  $email = trim($_POST["email"] ?? "");
  $pass  = $_POST["password"] ?? "";
  if (login($email, $pass)) {
    header("Location: dashboard.php");
    exit;
  }
  $error = "Neplatný email nebo heslo.";
}
?>
<!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Přihlášení – Podlahářství</title>
  <link rel="stylesheet" href="assets/style.css" />
</head>
<body>
  <div class="container" style="max-width:520px;padding-top:60px">
    <div class="panel">
      <div class="panel-head">
        <h2>Přihlášení</h2>
      </div>
      <div class="panel-body">
        <?php if ($error): ?>
          <div class="notice bad"><?=h($error)?></div>
        <?php endif; ?>

        <form method="post" class="grid" style="margin-top:12px">
          <label class="field span-2">
            <span class="muted">Email</span>
            <input class="input" name="email" type="email" required placeholder="admin@local" />
          </label>
          <label class="field span-2">
            <span class="muted">Heslo</span>
            <input class="input" name="password" type="password" required placeholder="admin123" />
          </label>
          <div class="span-2 right">
            <button class="btn btn-primary" type="submit">Přihlásit</button>
          </div>
          <div class="span-2 muted">
            Default: admin@local / admin123 (vytvoří se při prvním spuštění).
          </div>
        </form>
      </div>
    </div>
  </div>
</body>
</html>
