<?php
require_once __DIR__ . "/../src/init.php"; ensure_schema();
require_once __DIR__ . "/../src/auth.php";
require_once __DIR__ . "/../src/helpers.php";
require_login();

$cfg = require __DIR__ . "/../src/config.php";
$u = current_user(); $pdo=db();

$view = $_GET["view"] ?? "week"; // week|month
$week = $_GET["week"] ?? "";     // 2026-W02
$ym = $_GET["ym"] ?? "";         // 2026-01
$filterUser = (int)($_GET["user"] ?? 0);

// role limit: montér always locked to self
$roleUser = ($u["role"] === "montér") ? (int)$u["id"] : 0;
if ($roleUser) $filterUser = $roleUser;

$users = $pdo->query("SELECT id,name,role FROM users WHERE is_active=1 ORDER BY name")->fetchAll();

function dotClass(string $status): string {
  return match($status) {
    "Čeká" => "wait",
    "V běhu" => "run",
    "Hotovo" => "done",
    "Zrušeno" => "cancel",
    default => "run"
  };
}

$today = new DateTimeImmutable("now");

if ($view === "month") {
  if ($ym && preg_match("/^\d{4}-\d{2}$/", $ym)) $m = new DateTimeImmutable($ym."-01");
  else $m = new DateTimeImmutable($today->format("Y-m")."-01");

  $first = $m->modify("first day of this month");
  $last  = $m->modify("last day of this month");
  $gridStart = $first->modify("monday this week")->setTime(0,0);
  $gridEnd   = $last->modify("sunday this week")->setTime(0,0);

  $stmt = $pdo->prepare("
    SELECT o.id,o.title,o.address,o.status,o.start_date,o.end_date,o.flooring_type,o.area_m2,
           c.name AS client_name, u.name AS assigned_name, o.assigned_user_id
    FROM orders o
    JOIN clients c ON c.id=o.client_id
    LEFT JOIN users u ON u.id=o.assigned_user_id
    WHERE (o.start_date IS NOT NULL AND o.end_date IS NOT NULL)
      AND o.end_date >= ? AND o.start_date <= ?
      AND o.status <> 'Zrušeno'
      AND (?=0 OR o.assigned_user_id=?)
    ORDER BY o.start_date ASC
  ");
  $stmt->execute([$gridStart->format("Y-m-d"), $gridEnd->format("Y-m-d"), $filterUser, $filterUser]);
  $orders = $stmt->fetchAll();

  $prevYm = $first->modify("-1 month")->format("Y-m");
  $nextYm = $first->modify("+1 month")->format("Y-m");
} else {
  $dt = $week ? (DateTimeImmutable::createFromFormat("o-\WW", $week) ?: $today) : $today;
  $start = $dt->setISODate((int)$dt->format("o"), (int)$dt->format("W"), 1)->setTime(0,0);
  $end = $start->modify("+6 day");

  $stmt = $pdo->prepare("
    SELECT o.id,o.title,o.address,o.status,o.start_date,o.end_date,o.flooring_type,o.area_m2,
           c.name AS client_name, u.name AS assigned_name, o.assigned_user_id
    FROM orders o
    JOIN clients c ON c.id=o.client_id
    LEFT JOIN users u ON u.id=o.assigned_user_id
    WHERE (o.start_date IS NOT NULL AND o.end_date IS NOT NULL)
      AND o.end_date >= ? AND o.start_date <= ?
      AND o.status <> 'Zrušeno'
      AND (?=0 OR o.assigned_user_id=?)
    ORDER BY o.start_date ASC
  ");
  $stmt->execute([$start->format("Y-m-d"), $end->format("Y-m-d"), $filterUser, $filterUser]);
  $orders = $stmt->fetchAll();

  $prevWeek = $start->modify("-7 day")->format("o-\WW");
  $nextWeek = $start->modify("+7 day")->format("o-\WW");
  $days=[]; for($i=0;$i<7;$i++) $days[]=$start->modify("+$i day");
}
?>
<!doctype html><html lang="cs"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Kalendář – Podlahářství</title>
<link rel="stylesheet" href="assets/style.css">
</head><body>
<header class="topbar">
  <div class="brand"><div class="logo">🗓️</div><div>
    <div class="brand-title"><?=h($cfg["app"]["company_name"])?> – Kalendář</div>
    <div class="brand-sub">
      <?php if ($view==="month"): ?>Měsíc <?=h($first->format("m/Y"))?>
      <?php else: ?>Týden <?=h($start->format("d.m."))?> – <?=h($end->format("d.m.Y"))?>
      <?php endif; ?>
    </div>
  </div></div>
  <nav class="nav">
    <a href="dashboard.php">Dashboard</a>
    <a href="orders.php">Zakázky</a>
    <a class="active" href="calendar.php">Kalendář</a>
    <a href="clients.php">Klienti</a>
    <a href="pricelist.php">Ceník</a>
    <a href="logout.php">Odhlásit</a>
  </nav>
</header>

<main class="container">
  <section class="panel">
    <div class="panel-head">
      <h2><?= $view==="month" ? "Měsíční plán" : "Týdenní plán" ?></h2>
      <div class="right">
        <?php if ($view==="month"): ?>
          <a class="btn" href="calendar.php?view=month&ym=<?=$prevYm?>&user=<?=$filterUser?>">←</a>
          <a class="btn" href="calendar.php?view=month&user=<?=$filterUser?>">Dnes</a>
          <a class="btn" href="calendar.php?view=month&ym=<?=$nextYm?>&user=<?=$filterUser?>">→</a>
          <a class="btn" href="calendar.php?view=week&user=<?=$filterUser?>">Týden</a>
        <?php else: ?>
          <a class="btn" href="calendar.php?view=week&week=<?=$prevWeek?>&user=<?=$filterUser?>">←</a>
          <a class="btn" href="calendar.php?view=week&user=<?=$filterUser?>">Dnes</a>
          <a class="btn" href="calendar.php?view=week&week=<?=$nextWeek?>&user=<?=$filterUser?>">→</a>
          <a class="btn" href="calendar.php?view=month&user=<?=$filterUser?>">Měsíc</a>
        <?php endif; ?>
      </div>
    </div>
    <div class="panel-body">
      <form method="get" class="grid" style="margin-bottom:12px">
        <input type="hidden" name="view" value="<?=h($view)?>">
        <?php if ($view==="week"): ?><input type="hidden" name="week" value="<?=h($week ?: $start->format("o-\\WW"))?>"><?php endif; ?>
        <?php if ($view==="month"): ?><input type="hidden" name="ym" value="<?=h($ym ?: $first->format("Y-m"))?>"><?php endif; ?>
        <label class="field span-2"><span class="muted">Filtrovat podle montéra</span>
          <select class="input" name="user" onchange="this.form.submit()" <?= $roleUser ? "disabled" : "" ?>>
            <option value="0">Všichni</option>
            <?php foreach($users as $uu): ?>
              <option value="<?=(int)$uu["id"]?>" <?= $filterUser==(int)$uu["id"] ? "selected":"" ?>>
                <?=h($uu["name"])?> (<?=h($uu["role"])?>)
              </option>
            <?php endforeach; ?>
          </select>
        </label>
        <div class="field"><span class="muted">&nbsp;</span><button class="btn" type="submit">Použít</button></div>
      </form>

      <?php if ($view==="week"): ?>
        <div class="table-wrap"><table class="table">
          <thead><tr><th>Den</th><th>Zakázky v rozsahu dne</th></tr></thead>
          <tbody>
            <?php foreach($days as $d): $dStr=$d->format("Y-m-d"); ?>
              <?php $dayOrders=array_values(array_filter($orders, fn($o) => $o["start_date"] <= $dStr && $o["end_date"] >= $dStr)); ?>
              <tr>
                <td><strong><?=h($d->format("D"))?></strong><div class="muted"><?=h($d->format("d.m.Y"))?></div></td>
                <td>
                  <?php if (!$dayOrders): ?><div class="muted">—</div>
                  <?php else: ?>
                    <div style="display:flex;flex-direction:column;gap:10px">
                      <?php foreach($dayOrders as $o): ?>
                        <div class="notice">
                          <div style="display:flex;gap:10px;align-items:center;justify-content:space-between;flex-wrap:wrap">
                            <div>
                              <span class="badge"><span class="dot <?=dotClass($o["status"])?>"></span><?=h($o["status"])?></span>
                              <strong style="margin-left:8px">#<?= (int)$o["id"] ?> <?=h($o["client_name"])?> – <?=h($o["title"])?></strong>
                              <div class="muted"><?=h($o["address"])?> • <?=h($o["flooring_type"])?> • <?=h((string)$o["area_m2"])?> m²</div>
                              <div class="muted"><?=h($o["start_date"])?> → <?=h($o["end_date"])?> • Montér: <?=h($o["assigned_name"] ?? "—")?></div>
                            </div>
                            <div class="right">
                              <a class="btn" href="order_view.php?id=<?=(int)$o["id"]?>">Detail</a>
                              <a class="btn" href="print.php?id=<?=(int)$o["id"]?>&doc=zakazka" target="_blank">Tisk</a>
                            </div>
                          </div>
                        </div>
                      <?php endforeach; ?>
                    </div>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table></div>
      <?php else: ?>
        <?php
          $weeks = (int)ceil(($gridEnd->getTimestamp() - $gridStart->getTimestamp()) / (7*86400));
          $cells=[]; for($i=0;$i<$weeks*7;$i++) $cells[] = $gridStart->modify("+$i day");
        ?>
        <div style="display:grid;grid-template-columns:repeat(7, minmax(0,1fr));gap:10px">
          <?php foreach($cells as $day): $ds=$day->format("Y-m-d"); ?>
            <?php $inMonth = $day->format("Y-m")===$first->format("Y-m"); ?>
            <?php $dayOrders=array_values(array_filter($orders, fn($o) => $o["start_date"] <= $ds && $o["end_date"] >= $ds)); ?>
            <div class="card" style="opacity:<?= $inMonth ? "1":"0.55" ?>;padding:10px">
              <div style="display:flex;justify-content:space-between;align-items:baseline">
                <strong><?=h($day->format("d"))?></strong>
                <span class="muted"><?=h($day->format("D"))?></span>
              </div>
              <div style="display:flex;flex-direction:column;gap:6px;margin-top:8px">
                <?php if (!$dayOrders): ?>
                  <span class="muted">—</span>
                <?php else: ?>
                  <?php foreach(array_slice($dayOrders,0,3) as $o): ?>
                    <a href="order_view.php?id=<?=(int)$o["id"]?>" style="text-decoration:none">
                      <span class="badge" style="width:100%;justify-content:space-between">
                        <span style="display:inline-flex;gap:8px;align-items:center">
                          <span class="dot <?=dotClass($o["status"])?>"></span>
                          <span>#<?= (int)$o["id"] ?> <?=h($o["client_name"])?></span>
                        </span>
                        <span class="muted"><?=h($o["assigned_name"] ?? "—")?></span>
                      </span>
                    </a>
                  <?php endforeach; ?>
                  <?php if (count($dayOrders) > 3): ?><span class="muted">+<?=count($dayOrders)-3?> dalších…</span><?php endif; ?>
                <?php endif; ?>
              </div>
            </div>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>
    </div>
  </section>
</main>
</body></html>
