<?php
declare(strict_types=1);

function db(): PDO {
  static $pdo = null;
  if ($pdo) return $pdo;

  $cfg = require __DIR__ . "/config.php";
  $path = $cfg["db"]["sqlite_path"];

  $dir = dirname($path);
  if (!is_dir($dir)) mkdir($dir, 0775, true);

  $pdo = new PDO("sqlite:" . $path, null, null, [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false,
  ]);

  $pdo->exec("PRAGMA foreign_keys = ON;");
  $pdo->exec("PRAGMA journal_mode = WAL;");

  return $pdo;
}
