<?php
require_once __DIR__ . "/../src/init.php";
ensure_schema();

require_once __DIR__ . "/../src/auth.php";
require_once __DIR__ . "/../src/helpers.php";
require_login();

$cfg = require __DIR__ . "/../src/config.php";
$pdo = db();

$id = (int)($_GET["id"] ?? 0);
if ($id>0) require_order_access($id);
$doc = $_GET["doc"] ?? "nabidka"; // nabidka | zakazka | protokol

$stmt = $pdo->prepare("
  SELECT o.*, c.name AS client_name, c.phone AS client_phone, c.email AS client_email, c.address AS client_address, c.ico, c.dic,
         u.name AS assigned_name
  FROM orders o
  JOIN clients c ON c.id=o.client_id
  LEFT JOIN users u ON u.id=o.assigned_user_id
  WHERE o.id=?
");
$stmt->execute([$id]);
$o = $stmt->fetch();
if (!$o) { http_response_code(404); exit("Zakázka nenalezena"); }

$it = $pdo->prepare("SELECT * FROM order_items WHERE order_id=? ORDER BY kind, id");
$it->execute([$id]);
$items = $it->fetchAll();

$tot = order_totals($id);

$docNo = strtoupper(match($doc) { "zakazka"=>"ZAK", "protokol"=>"PRO", default=>"NAB" }) . "-" . date("Y") . "-" . str_pad((string)$id, 4, "0", STR_PAD_LEFT);

$title = match($doc) {
  "zakazka" => "Zakázkový list",
  "protokol" => "Předávací protokol",
  default => "Nabídka / Rozpočet"
};

function section_items(array $items, string $kind): array {
  return array_values(array_filter($items, fn($i) => $i["kind"] === $kind));
}
$kinds = ["Materiál","Práce","Doprava","Ostatní"];
?>
<!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?=h($title)?> – #<?=$id?></title>
  <link rel="stylesheet" href="assets/style.css" />
</head>
<body>
<!-- print view: use full width so tables fit across the page -->
<main class="container container-full" style="padding-top:18px">
  <div class="panel">
    <div class="panel-head">
      <h2><?=h($title)?> – zakázka #<?=$id?></h2>
      <div class="right no-print">
        <button class="btn btn-primary" onclick="window.print()">Tisknout</button>
        <a class="btn" href="order_view.php?id=<?=$id?>">Zpět</a>
      </div>
    </div>
    <div class="panel-body">
      <div class="grid">
        <div>
          <div style="display:flex;gap:12px;align-items:center">
            <?php if (file_exists(__DIR__ . "/assets/logo.png")): ?>
              <img src="assets/logo.png" alt="logo" style="height:44px;width:auto;border-radius:10px;border:1px solid rgba(255,255,255,.10)" />
            <?php else: ?>
              <div class="logo" style="width:44px;height:44px">🧱</div>
            <?php endif; ?>
            <div>
              <div class="muted">Dodavatel</div>
          <div><strong><?=h($cfg["app"]["company_name"])?></strong></div>
              <div class="muted">Doklad: <strong><?=h($docNo)?></strong></div>
          <div class="muted"><?=h($cfg["app"]["company_phone"])?> • <?=h($cfg["app"]["company_email"])?></div>
        </div>
        <div>
          <div class="muted">Odběratel</div>
          <div><strong><?=h($o["client_name"])?></strong></div>
          <div class="muted"><?=h($o["client_phone"] ?? "")?> <?= $o["client_email"] ? "• ".h($o["client_email"]) : "" ?></div>
          <div class="muted"><?=h($o["client_address"] ?? "")?></div>
          <div class="muted"><?= $o["ico"] ? "IČO: ".h($o["ico"])." " : "" ?><?= $o["dic"] ? "DIČ: ".h($o["dic"]) : "" ?></div>
        </div>

        <div class="span-2">
          <div class="muted">Zakázka</div>
          <div><strong><?=h($o["title"])?></strong></div>
          <div class="muted">Adresa: <?=h($o["address"])?> • Typ: <?=h($o["flooring_type"])?> • Plocha: <?=h((string)$o["area_m2"])?> m²</div>
          <div class="muted">Termín: <?=h((string)($o["start_date"] ?? "—"))?> → <?=h((string)($o["end_date"] ?? "—"))?> • Montér: <?=h($o["assigned_name"] ?? "—")?></div>
        </div>
      </div>

      <?php if ($doc !== "protokol"): ?>
        <h3 style="margin-top:16px;margin-bottom:8px">Rozpočet (položkově)</h3>
        <div class="table-wrap">
          <table class="table">
            <thead>
              <tr><th>Druh</th><th>Název</th><th>MJ</th><th>Množství</th><th>Cena/MJ</th><th>Řádek</th></tr>
            </thead>
            <tbody>
              <?php foreach ($kinds as $k): ?>
                <?php $subset = section_items($items, $k); ?>
                <?php if (!$subset) continue; ?>
                <tr><td colspan="6"><strong><?=h($k)?></strong></td></tr>
                <?php foreach ($subset as $it): ?>
                  <?php $sum = (float)$it["qty"]*(int)$it["unit_price_czk"]; ?>
                  <tr>
                    <td><?=h($it["kind"])?></td>
                    <td><?=h($it["name"])?><div class="muted"><?=h($it["note"] ?? "")?></div></td>
                    <td><?=h($it["unit"])?></td>
                    <td><?=h((string)$it["qty"])?></td>
                    <td><?=czk((int)$it["unit_price_czk"])?></td>
                    <td><?=czk((int)round($sum))?></td>
                  </tr>
                <?php endforeach; ?>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>

        <div class="right" style="margin-top:12px">
          <div class="notice">
            <div class="muted">Mezisoučet: <?=czk((int)$tot["subtotal"])?></div>
            <div class="muted">Sleva: <?=czk((int)$tot["discount"])?></div>
            <div class="muted">Základ: <?=czk((int)round($tot["after_discount"]))?></div>
            <div class="muted">DPH (<?=h((string)$tot["vat_rate"])?>%): <?=czk((int)round($tot["vat"]))?></div>
            <div><strong>Celkem: <?=czk((int)round($tot["total"]))?></strong></div>
          </div>
        </div>
      <?php else: ?>
        <h3 style="margin-top:16px;margin-bottom:8px">Předání díla</h3>
        <div class="notice">
          <div><strong>Prohlášení</strong></div>
          <div class="muted" style="margin-top:8px">
            Potvrzuji převzetí díla bez zjevných vad / s výhradami: ________________________________.
          </div>
          <div class="muted" style="margin-top:8px">
            Závady a připomínky: ________________________________________________________________.
          </div>
          <div class="muted" style="margin-top:8px">
            Datum předání: ____________________  Podpis zákazníka: ______________________________.
          </div>
          <div class="muted" style="margin-top:8px">
            Podpis dodavatele: __________________  Poznámka: ____________________________________.
          </div>
        </div>
      <?php endif; ?>

      <div class="muted" style="margin-top:12px">
        Poznámka: <?= nl2br(h($o["note"] ?? "")) ?>
      </div>
    </div>
  </div>
</main>
</body>
</html>
