<?php
require_once __DIR__ . "/../src/init.php"; ensure_schema();
require_once __DIR__ . "/../src/auth.php";
require_once __DIR__ . "/../src/helpers.php";
require_login();

$cfg = require __DIR__ . "/../src/config.php";
$u = current_user(); $pdo = db();
$id=(int)($_GET["id"]??0);

$st=$pdo->prepare("SELECT * FROM clients WHERE id=?"); $st->execute([$id]); $c=$st->fetch();
if(!$c){ http_response_code(404); exit("Klient nenalezen"); }

$where="WHERE o.client_id=?"; $params=[$id];
if($u["role"]==="montér"){ $where.=" AND o.assigned_user_id=?"; $params[]=(int)$u["id"]; }

$os=$pdo->prepare("SELECT o.*, u.name AS assigned_name FROM orders o LEFT JOIN users u ON u.id=o.assigned_user_id $where
ORDER BY COALESCE(o.end_date,o.start_date,o.created_at) DESC LIMIT 300");
$os->execute($params); $orders=$os->fetchAll();
?>
<!doctype html><html lang="cs"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Klient – <?=h($c["name"])?> – Podlahářství</title><link rel="stylesheet" href="assets/style.css">
</head><body>
<header class="topbar">
  <div class="brand"><div class="logo">👤</div><div>
    <div class="brand-title"><?=h($cfg["app"]["company_name"])?> – Klient</div>
    <div class="brand-sub"><?=h($c["name"])?> • <?=h($u["name"])?> (<?=h($u["role"])?>)</div>
  </div></div>
  <nav class="nav">
    <a href="dashboard.php">Dashboard</a>
    <a href="orders.php">Zakázky</a>
    <a href="calendar.php">Kalendář</a>
    <a class="active" href="clients.php">Klienti</a>
    <a href="pricelist.php">Ceník</a>
    <a href="logout.php">Odhlásit</a>
  </nav>
</header>
<main class="container">
  <section class="panel">
    <div class="panel-head"><h2><?=h($c["name"])?></h2><div class="right"><a class="btn" href="orders.php?q=<?=urlencode($c["name"])?>">Hledat zakázky</a></div></div>
    <div class="panel-body">
      <div class="grid">
        <div><div class="muted">Kontakt</div><div><strong><?=h($c["phone"]??"—")?></strong></div><div class="muted"><?=h($c["email"]??"")?></div></div>
        <div><div class="muted">Adresa</div><div><strong><?=h($c["address"]??"—")?></strong></div></div>
        <div class="span-2"><div class="muted">Poznámka</div><div><?=nl2br(h($c["note"]??""))?></div></div>
      </div>
    </div>
  </section>

  <section class="panel">
    <div class="panel-head"><h2>Historie zakázek</h2><div class="muted"><?=count($orders)?> záznamů</div></div>
    <div class="panel-body">
      <div class="table-wrap"><table class="table">
        <thead><tr><th>ID</th><th>Název</th><th>Typ</th><th>Termín</th><th>Status</th><th>Montér</th><th>Akce</th></tr></thead>
        <tbody>
          <?php foreach($orders as $o): ?>
            <tr>
              <td class="muted">#<?= (int)$o["id"] ?></td>
              <td><strong><?=h($o["title"])?></strong><div class="muted"><?=h($o["address"])?></div></td>
              <td><?=h($o["flooring_type"])?></td>
              <td><?=h((string)($o["start_date"]??"—"))?> → <?=h((string)($o["end_date"]??"—"))?></td>
              <td><?=h($o["status"])?></td>
              <td><?=h($o["assigned_name"]??"—")?></td>
              <td><a class="btn" href="order_view.php?id=<?=(int)$o["id"]?>">Detail</a></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table></div>
    </div>
  </section>
</main>
</body></html>
